/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessCascadeExecutor;
import com.huawei.ism.drm.recovery.framework.util.MotionPausedUtils;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class RecoveryProcessSerialExecutor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessSerialExecutor.class);
    private final String name;
    private final List<IProcessor> processors = new ArrayList<IProcessor>();
    private int curProcessorIndex = -1;
    private boolean containsPause = false;
    private boolean isAfterPause = false;

    /*
     * WARNING - void declaration
     */
    private RecoveryProcessSerialExecutor(String name, List<? extends IProcessor> processorList) {
        if (name == null || processorList == null || processorList.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        for (IProcessor iProcessor : processorList) {
            void var4_4;
            RecoveryProcessor reProcessor;
            if (iProcessor instanceof RecoveryProcessor && null != (reProcessor = (RecoveryProcessor)iProcessor).getNextCascadeProcessor()) {
                RecoveryProcessCascadeExecutor recoveryProcessCascadeExecutor = RecoveryProcessCascadeExecutor.createExecutor(reProcessor);
            }
            this.processors.add((IProcessor)var4_4);
        }
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(List<? extends IProcessor> recoveryProcessors, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        RecoveryProcessSerialExecutor template = new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), recoveryProcessors);
        return template;
    }

    private static String getTemplateName() {
        return "RCT_" + UUIDGenerator.getUUID();
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutor(Set<RecoveryProcessor> recoveryProcessors, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        return new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), sortedProcessors);
    }

    public static RecoveryProcessSerialExecutor createRecoveryProcessExecutorSort(Set<RecoveryProcessor> recoveryProcessors) {
        if (null == recoveryProcessors || recoveryProcessors.isEmpty()) {
            return null;
        }
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(recoveryProcessors);
        return new RecoveryProcessSerialExecutor(RecoveryProcessSerialExecutor.getTemplateName(), sortedProcessors);
    }

    public boolean isAllProcessorCompleted() {
        boolean result;
        boolean bl = result = this.curProcessorIndex == this.processors.size() - 1;
        if (VerifyUtil.isEmpty(this.processors)) {
            return result;
        }
        return this.processors.stream().noneMatch(processor -> {
            boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
            if (!isRecoveryProcessor) {
                return false;
            }
            RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
            if (recoveryProcessor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue()) {
                return true;
            }
            Set childProcs = recoveryProcessor.getChildProc();
            if (VerifyUtil.isEmpty((Collection)childProcs)) {
                return false;
            }
            return childProcs.stream().anyMatch(child -> child.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        });
    }

    public DrmEnumDefine.RecoveryPlanExecuteResultE getLastProcessorResult() {
        DrmEnumDefine.RecoveryPlanExecuteResultE result = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER;
        if (null != this.processors && !this.processors.isEmpty()) {
            for (int ii = this.processors.size() - 1; ii >= 0; --ii) {
                RecoveryProcessor recoveryProcessor = (RecoveryProcessor)this.processors.get(ii);
                if (!recoveryProcessor.getIsEnabled().booleanValue()) continue;
                return DrmEnumDefine.RecoveryPlanExecuteResultE.getType((int)recoveryProcessor.getProcStatus());
            }
        }
        return result;
    }

    public boolean process(RecoveryProcessorContext context) {
        return this.callProcessors(context);
    }

    public String getName() {
        return this.name;
    }

    private boolean callProcessors(RecoveryProcessorContext context) {
        IProcessor processor = null;
        boolean isNormal = true;
        try {
            this.containsPause = MotionPausedUtils.containsPausedProcessor(context, this.processors);
            int size = this.processors.size();
            for (int i = 0; i < size; ++i) {
                processor = this.processors.get(i);
                if (processor == null) continue;
                this.curProcessorIndex = i;
                boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
                if (isRecoveryProcessor && this.isNeedSkip(context, (RecoveryProcessor)processor)) continue;
                boolean processResult = processor.process(context);
                if (isRecoveryProcessor) {
                    RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
                    ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor(recoveryProcessor);
                }
                if (!processResult) {
                    isNormal = false;
                } else {
                    if (!this.isMotionPaused(context, processor)) continue;
                    this.createRecoveryProcessorDetail(context);
                }
                break;
            }
        }
        catch (Exception e) {
            String processorName = processor != null ? processor.getName() : "";
            logger.error((Object)"Calling processor failed. Processor: %s, Message: %s", 90160758784001L, (Object[])new String[]{processorName, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setContextErrorCode(context, e);
            isNormal = false;
        }
        return isNormal;
    }

    private boolean isNeedSkip(RecoveryProcessorContext context, RecoveryProcessor processor) {
        if (!processor.getIsEnabled().booleanValue()) {
            logger.debug((Object)"Processor %s will be skipped, because it is not enabled.", new Object[]{processor.getName()});
            return true;
        }
        return this.containsPause && this.checkMotionContinue(context, (IProcessor)processor);
    }

    private void createRecoveryProcessorDetail(RecoveryProcessorContext context) {
        int nextIndex = this.curProcessorIndex + 1;
        if (nextIndex == this.processors.size()) {
            return;
        }
        IProcessor processor = this.processors.get(nextIndex);
        boolean isBaseRecoveryProcessor = processor instanceof BaseRecoveryProcessor;
        if (!isBaseRecoveryProcessor) {
            return;
        }
        BaseRecoveryProcessor baseRecoveryProcessor = (BaseRecoveryProcessor)processor;
        this.createProcessorDetail(baseRecoveryProcessor, context, DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED);
        context.setAttribute("PLAN_PROGRESS_COMPLETED_NUM", (Object)nextIndex);
    }

    public Boolean changeProcessorDetailStatus(RecoveryProcessorContext context) {
        for (IProcessor processor : this.processors) {
            boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
            if (!isRecoveryProcessor) continue;
            BaseRecoveryProcessor baseRecoveryProcessor = (BaseRecoveryProcessor)processor;
            String processorClassName = processor.getClass().getName();
            if (processorClassName.contains("RegionBetweenRecoveryProcessor") || processorClassName.contains("RegionWithinRecoveryProcessor")) {
                if (!baseRecoveryProcessor.getIsEnabled().booleanValue()) {
                    logger.debug((Object)"The processor %s is not enable.", new Object[]{baseRecoveryProcessor.getProcName()});
                    continue;
                }
                this.resetChildProcDetailStatus(context, baseRecoveryProcessor);
                logger.info((Object)"The processor %s do resetChildProcDetailStatus finished.", new Object[]{baseRecoveryProcessor.getProcName()});
                return false;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != baseRecoveryProcessor.getProcStatus()) continue;
            this.createProcessorDetail(baseRecoveryProcessor, context, DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
        }
        return false;
    }

    private void resetChildProcDetailStatus(RecoveryProcessorContext context, BaseRecoveryProcessor baseRecoveryProcessor) {
        baseRecoveryProcessor.setContextRef(context);
        baseRecoveryProcessor.beforeExecRecoveryProcessor();
        this.createProcessorDetail(baseRecoveryProcessor, context, DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
        Set childProc = baseRecoveryProcessor.getChildProc();
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        Map<String, List<RecoveryProcessorDetail>> details = recoveryPlanService.getRecoveryProcessorDetailsByLogId(context.getRecoveryPlan().getPlanId(), context.getRecoveryLogId()).stream().filter(detail -> !VerifyUtil.isEmpty((Collection)detail.getChildDetails())).flatMap(detail -> detail.getChildDetails().stream()).filter(detail -> DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != detail.getProcessStatus()).collect(Collectors.groupingBy(RecoveryProcessorDetail::getProcId));
        for (RecoveryProcessor child : childProc) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue() != child.getProcStatus() && DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue() != child.getProcStatus()) {
                logger.debug((Object)"The procStatus %s of child processor %s no need to update.", new Object[]{String.valueOf(child.getProcStatus()), child.getProcName()});
                continue;
            }
            if (!(child instanceof BaseRecoveryProcessor)) {
                logger.debug((Object)"The child processor %s is not instanceof BaseRecoveryProcessor.", new Object[]{child.getProcName()});
                continue;
            }
            List<RecoveryProcessorDetail> childDetails = details.get(child.getProcId());
            if (VerifyUtil.isEmpty(childDetails)) {
                this.createProcessorDetail((BaseRecoveryProcessor)child, context, DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
                continue;
            }
            for (RecoveryProcessorDetail recoveryProcessorDetail : childDetails) {
                recoveryProcessorDetail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                recoveryProcessService.updateRecoveryProcessDetail(recoveryProcessorDetail);
            }
        }
        recoveryProcessService.updateRecoveryProcessor((RecoveryProcessor)baseRecoveryProcessor);
    }

    private void createProcessorDetail(BaseRecoveryProcessor baseRecoveryProcessor, RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteResultE status) {
        String parentDetailId = null;
        if (baseRecoveryProcessor.getParentProc() != null) {
            parentDetailId = baseRecoveryProcessor.getParentProc().getCurProcessDetail().getDetailId();
        }
        RecoveryProcessor preProcessor = RecoveryProcessUtil.getValidPreviousProcessor(baseRecoveryProcessor);
        RecoveryProcessor nextProcessor = RecoveryProcessUtil.getValidNextProcessor(baseRecoveryProcessor);
        String previousProcId = preProcessor != null ? preProcessor.getProcId() : null;
        String nextProcId = nextProcessor != null ? nextProcessor.getProcId() : null;
        RecoveryProcessorDetail procDetail = new RecoveryProcessorDetail();
        procDetail.setLogId(context.getRecoveryLogId());
        procDetail.setProcessName(baseRecoveryProcessor.getProcName());
        procDetail.setNextProcId(nextProcId);
        procDetail.setPreviousProcId(previousProcId);
        procDetail.setParentDetailId(parentDetailId);
        procDetail.setProcId(baseRecoveryProcessor.getProcId());
        procDetail.setProcessStatus(status.getValue());
        baseRecoveryProcessor.createRecoveryProcessorDetail(procDetail);
    }

    private boolean checkMotionContinue(RecoveryProcessorContext context, IProcessor processor) {
        if (!DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals(context.getAttribute("PLAN_EXEXUTE_TYPE"))) {
            return false;
        }
        if (!Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_CONTINUE_PROCESS")))) {
            return false;
        }
        if (this.isAfterPause) {
            return false;
        }
        if (MotionPausedUtils.isPausedProcessor(context, processor)) {
            this.isAfterPause = true;
        }
        logger.debug((Object)"Processor %s will be skipped, because it was executed before pausing.", new Object[]{processor.getName()});
        return true;
    }

    public boolean checkMotionCancel(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        if (context == null) {
            return false;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        boolean isContinue = Boolean.parseBoolean(String.valueOf(context.getAttribute("IS_CONTINUE_PROCESS")));
        boolean isPaused = DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() == recoveryPlan.getPlanStatus();
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)recoveryPlanExecuteType) && !isContinue && isPaused;
    }

    private boolean isMotionPaused(RecoveryProcessorContext context, IProcessor processor) {
        logger.info((Object)"Current processor is %s.", new Object[]{processor.getName()});
        boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
        if (!MotionPausedUtils.isMotionPaused(context) || !MotionPausedUtils.isPausedProcessor(context, processor)) {
            return false;
        }
        if (isRecoveryProcessor) {
            RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
            RecoveryProcessor nextProcessor = recoveryProcessor.getNextProcessor();
            int procStatus = Optional.ofNullable(nextProcessor).map(RecoveryProcessor::getProcStatus).orElse(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            if (procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() || procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() || procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue()) {
                logger.error((Object)String.format(Locale.ROOT, "Processor status is %s and should not be paused.", procStatus));
                return false;
            }
            context.setAttribute("PLAN_PROGRESS_RATIO", (Object)recoveryProcessor.getProgressRatio());
        } else {
            context.setAttribute("PLAN_PROGRESS_RATIO", (Object)100);
        }
        context.setAttribute("IS_PAUSED_PROCESS", (Object)true);
        return true;
    }

    private void setContextErrorCode(RecoveryProcessorContext context, Throwable ex) {
        if (ex instanceof LegoCheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoCheckedException)ex).getErrorCode());
        } else if (ex instanceof LegoUncheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoUncheckedException)ex).getErrorCode());
        } else {
            context.setAttribute("icommand:errorcode", (Object)0x200909L);
        }
    }
}

