/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.recovery.framework.provider.RefactorConfigurationProviderMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class ReprotectCallBackExcuteRecoveryTask
implements ICallBackExcuteRecoveryTask {
    private static final Log logger = LogFactory.getInstance(ReprotectCallBackExcuteRecoveryTask.class);

    public void afterExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        DrmEnumDefine.AppType appType;
        String isReversedInGlobalSetting = (String)context.getAttribute("isReserved");
        if ("true".equalsIgnoreCase(isReversedInGlobalSetting)) {
            logger.debug((Object)"the isReserved is true");
            return;
        }
        RefactorConfigurationProviderMgr refactorCfgProviderMgr = RefactorConfigurationProviderMgr.getInstance();
        IRefactorConfigurationProvider refacotryprovider = refactorCfgProviderMgr.getRefactorConfigurationProvider((appType = RecoveryServiceUtil.getAppType(recoveryPlan)).name());
        if (refacotryprovider == null) {
            logger.error((Object)("refacotryprovider is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        if (!String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes)) {
            logger.info((Object)"refactor recoveryplan not success: %s", new Object[]{recoveryPlan.getPlanId()});
            return;
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan planWithProcess = planService.getRecoveryPlan(recoveryPlan.getPlanId(), true, false);
        if (planWithProcess == null) {
            logger.error((Object)("The recovery plan does not exist. Name:" + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
        Set definitions = planWithProcess.getRecoveryProcesses();
        if (VerifyUtil.isEmpty((Collection)definitions)) {
            return;
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.error((Object)("provicer is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
    }

    public void beforeExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
    }
}

