/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.template;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefTemplate;
import com.huawei.ism.drm.recovery.framework.template.RecoveryProcessDefTemplateMgr;
import com.huawei.ism.drm.recovery.framework.template.RecoveryProcessDefTemplateParaser;
import com.huawei.lego.core.sdk.base.IBundleHelper;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class RecoveryProcessDefTemplateLoader
implements InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessDefTemplateLoader.class);
    private static RecoveryProcessDefTemplateLoader sInstance = new RecoveryProcessDefTemplateLoader();
    private Properties extensionPoints;
    private IBundleHelper bundleHelper;

    private RecoveryProcessDefTemplateLoader() {
    }

    public static RecoveryProcessDefTemplateLoader getInstance() {
        return sInstance;
    }

    public Properties getExtensionPoints() {
        return this.extensionPoints;
    }

    public void setExtensionPoints(Properties extensionPoints) {
        this.extensionPoints = extensionPoints;
    }

    public IBundleHelper getBundleHelper() {
        return this.bundleHelper;
    }

    public void setBundleHelper(IBundleHelper bundleHelper) {
        this.bundleHelper = bundleHelper;
    }

    public void afterPropertiesSet() {
        logger.info((Object)"Start to loading recovery process template configuration.", 90160758784000L);
        RecoveryProcessDefTemplateParaser parser = new RecoveryProcessDefTemplateParaser();
        List urls = AdapterUtils.getAllClassPathEntries((String)"recovery/*ProcessDefinition.xml");
        for (URL url : urls) {
            parser.readTemplateFile(url);
        }
        try {
            Set<RecoveryProcessDefTemplate> templates = parser.parseTemplateFile();
            RecoveryProcessDefTemplateMgr templateMgr = RecoveryProcessDefTemplateMgr.getInstance();
            templateMgr.registerRecoveryProcessDefTemplates(templates);
        }
        catch (Exception e) {
            logger.error((Object)("Parsing and registering recovery process template failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public void destroy() {
    }
}

