/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.reprotect.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.reprotect.SaveReprotectedRpTransaction;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.ism.drm.system.plugin.DrmBaseApplication;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import org.springframework.transaction.support.TransactionCallback;

@Service(name="IReprotectService", desc="", interfaceClass=IReprotectService.class)
public class ReprotectServiceImpl
extends DrmBaseService
implements IReprotectService {
    private static final Log logger = LogFactory.getInstance(ReprotectServiceImpl.class);
    private IMessageCenter messageCenter;

    public ReprotectServiceImpl(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public void saveReprotectUpdate(RecoveryPlan recoveryPlan) {
        SaveReprotectedRpTransaction callBack = new SaveReprotectedRpTransaction(recoveryPlan, true);
        CommonDAOLocator.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callBack);
    }

    public void sendReprotectSuccessMsg(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || recoveryPlan.getProtectGroups() == null || recoveryPlan.getProtectGroups().isEmpty()) {
            logger.debug((Object)"param is null ,not sendReprotectSuccessMsg");
            return;
        }
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            protectGroups.add(protectGroup);
        }
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(100001L);
        mu.setObj(protectGroups);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(DrmBaseApplication.class.getName());
        this.messageCenter.sendMessage(mu);
        logger.info((Object)"Sending reprotect success message. Name:%s", new Object[]{recoveryPlan.getName()});
    }
}

