/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.security.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.wcc.util.alarm.CertAuthSuccess;
import com.huawei.lego.comm.security.ICertificateServerCallback;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class CertificateAlarmService
implements ICertificateServerCallback,
SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(CertificateAlarmService.class);

    public void success(CertAuthSuccess certAuthSuccess, String moUuid) {
        if (certAuthSuccess.getCertAuthSuccessType() == 2) {
            AlarmReporter.restoreAlarm(52625500L, certAuthSuccess.getIpAddress());
            return;
        }
        AlarmReporter.restoreAlarm(52625444L, moUuid);
        AlarmReporter.restoreAlarm(52625445L, moUuid);
    }

    public void failForCertExpired(String ipAddress, String moUuid) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        String[] alarmParams = new String[]{ipInfo, moUuid, new LegoMoGenerator().getInstallServerIp()};
        AlarmReporter.sendAlarm(52625444L, moUuid, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alarmParams);
    }

    public void failForCertExpiring(String ipAddress, String moUuid, int expireDays) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        String string = ipInfo = ipInfo != null ? ipInfo : ipAddress;
        if (expireDays < 0) {
            LOGGER.warn((Object)"Failed to execute failForCertWillBeInvalidity, cause expireDays is less than 0.");
            return;
        }
        String[] alarmParams = new String[]{String.valueOf(expireDays), ipInfo};
        AlarmReporter.sendAlarm(52625500L, moUuid, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alarmParams);
    }

    public void failForCertNoTrust(String ipAddress, String moUuid) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        String[] alarmParams = new String[]{ipInfo, moUuid};
        AlarmReporter.sendAlarm(52625445L, moUuid, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, alarmParams);
    }

    public void failForRevokedCert(String ipAddress, Set<String> set) {
        LOGGER.info((Object)"Revoked cert:ip:%s subjectDN:%s", new Object[]{ipAddress, String.valueOf(set)});
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        set = set == null ? new HashSet() : set;
        String[] params = new String[]{ipInfo, String.join((CharSequence)"; ", set)};
        AlarmReporter.sendAlarm(52625513L, null, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.CRITICAL, params);
    }

    public void restoreForRevokedCert(String ipAddress) {
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        ipInfo = ipInfo != null ? ipInfo : ipAddress;
        AlarmReporter.restoreAlarm(52625513L, ipInfo);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && !LegoConfig.getInstance().getBoolean("cert.auth.switch", Boolean.FALSE).booleanValue()) {
            this.clearCertAlarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCertAlarm() {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            long clearTime = System.currentTimeMillis();
            List<String> entityList = this.queryAlarm(session);
            if (!VerifyUtil.isEmpty(entityList)) {
                Session finalSession = session;
                List<String> annotationList = entityList.stream().map(entity -> this.queryAnnotationMaxIdForEntity(finalSession, (String)entity)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                this.updateAlarm(session, clearTime, entityList);
                this.updateAnnotation(session, clearTime, annotationList);
            }
            transaction.commit();
        }
        catch (Exception ex) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                LOGGER.error((Object)"Start system,clear Cert Alarm fail,msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private List<String> queryAlarm(Session session) {
        String sql = "select ENTITY from T_ALARM where CLEAR_STATUS='0' and (ENTITY like '%0x3230024%' or ENTITY like '%0x3230025%' or ENTITY like '%0x323005C%' or ENTITY like '%0x3230069%');";
        NativeQuery query = session.createSQLQuery(sql);
        return query.list();
    }

    private Optional<String> queryAnnotationMaxIdForEntity(Session session, String entity) {
        if (entity == null) {
            throw new LegoCheckedException("entity is null.");
        }
        String sql = "select max(ann.id) from T_annotation ann where ann.entity = :entity";
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameter("entity", (Object)entity);
        Object result = query.uniqueResult();
        if (result == null) {
            return Optional.empty();
        }
        if (result instanceof BigInteger) {
            return Optional.of(String.valueOf(result));
        }
        throw new IllegalStateException("Non-String value returned from SQL query.");
    }

    private void updateAlarm(Session session, long clearTime, List<String> entityList) {
        String updateSql = "update T_alarm set CLEAR_STATUS='1',CLEAR_USER='system',CLEAR_TIME=:clearTime where ENTITY in (:entityList);";
        NativeQuery query = session.createSQLQuery(updateSql);
        query.setParameter("clearTime", (Object)clearTime);
        query.setParameterList("entityList", entityList);
        query.executeUpdate();
    }

    private void updateAnnotation(Session session, long clearTime, List<String> annotationList) {
        String updateSql = "update T_ANNOTATION set CLEAR_STATUS='1',CLEAR_USER='system',CLEAR_TIME=:clearTime where id in (:annotationList);";
        NativeQuery query = session.createSQLQuery(updateSql);
        query.setParameter("clearTime", (Object)clearTime);
        query.setParameterList("annotationList", annotationList);
        query.executeUpdate();
    }
}

