/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;

@Service(name="com.huawei.ism.drm.site.sdk.service.IManagementServerService", desc="", interfaceClass=IManagementServerService.class)
public class ManagementServerServiceImpl
extends IsmBaseService
implements IManagementServerService {
    private static final Log logger = LogFactory.getInstance(ManagementServerServiceImpl.class);

    private void validateName(String name) {
        if (VerifyUtil.isEmpty((String)name)) {
            logger.error((Object)("name is emtpty, " + name), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParam((String)name)) {
            logger.error((Object)("name illegal, " + name), 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ManagementServer where devAlias=?", new Object[]{name});
        if (find != null && !find.isEmpty()) {
            logger.error((Object)("find, devAlias=" + name), 90160758784000L);
            throw new LegoCheckedException(1073947392L);
        }
    }

    public void updateServer(ManagementServer server) {
        if (server == null) {
            logger.error((Object)"parameter is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServer(server.getUuid());
        if (null == replica) {
            logger.error((Object)("not exsit, " + server.getUuid()), 90160758784000L);
            throw new LegoCheckedException(2117645L);
        }
        this.updateBasicInfo(replica, server.getName());
        CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)replica);
    }

    private void updateBasicInfo(ManagementServer replica, String newName) {
        logger.debug((Object)"updateBasicInfo");
        this.updateBasicInfoForLocal(replica, newName);
    }

    private void updateBasicInfoForLocal(ManagementServer replica, String newName) {
        if (VerifyUtil.isEmpty((String)newName) || newName.equals(replica.getName())) {
            logger.info((Object)"not changed.");
            return;
        }
        this.validateName(newName);
        replica.setName(newName);
    }

    public ManagementServer getServerInfo() {
        logger.debug((Object)"getServerInfo");
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "serverType", (Object)0);
        if (server != null) {
            server.setUser(null);
            server.setPwd(null);
            String version = ResourceUtil.getValue("sysversion");
            server.setVersion(version);
        }
        return server;
    }

    public List<ManagementServer> getServers() {
        logger.debug((Object)"getServers");
        ArrayList<ManagementServer> servers = new ArrayList<ManagementServer>();
        servers.add(this.getServerInfo());
        return servers;
    }

    public ManagementServer getServer(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)"uuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)uuid);
        return server;
    }
}

