/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.service.impl;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteCheckService;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.service.impl.BatchResultUtil;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.site.sdk.service.ISiteService", desc="", interfaceClass=ISiteService.class)
public class SiteServiceImpl
extends IsmBaseService
implements ISiteService {
    private static final long USER_ADMIN = 1L;
    private static final Log logger = LogFactory.getInstance(SiteServiceImpl.class);
    private List<ISiteCheckService> siteCheckServices = new ArrayList<ISiteCheckService>();

    public synchronized String createSite(Site site, Long userId) {
        String serverUuid = site.getServerUuid();
        ManagementServer server = ((IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class)).getServer(serverUuid);
        if (server == null) {
            throw new LegoCheckedException(2117645L);
        }
        if (this.isSiteExist(site.getName())) {
            throw new LegoCheckedException(1073947392L);
        }
        this.isExceedMaxSiteNum(0);
        if (this.isCloudSite(site).booleanValue()) {
            logger.error((Object)"Do not suppport CloudSite");
            throw new LegoCheckedException(100663460L, "Do not suppport CloudSite.");
        }
        site.setSiteId(UUIDGenerator.getUUID());
        site.setSiteType(0);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)site);
        this.grandSiteScope(userId, site.getSiteId());
        return site.getSiteId();
    }

    private void grandSiteScope(Long userId, String siteId) {
        if (null == userId) {
            ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(Long.valueOf(1L), new String[]{siteId});
        } else {
            ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(userId, new String[]{siteId});
        }
    }

    private void isExceedMaxSiteNum(int siteType) {
        long count = CommonDAOLocator.getBaseDao().getTotalCount("select count(*) from Site as site where site.siteType = ?", new Object[]{siteType});
        if (32L <= count) {
            logger.error((Object)("current site num:" + count), 90160758786870L);
            throw new LegoCheckedException(1073947658L);
        }
    }

    public void updateSite(Site site, String siteName, Long userId) {
        if (null == site) {
            throw new LegoCheckedException(1073947393L);
        }
        Site replica = this.getSite(site.getSiteId());
        if (null == replica) {
            throw new LegoCheckedException(1073947394L);
        }
        String oldName = replica.getName();
        String oldDesc = replica.getDescription();
        String newName = site.getName();
        String newDesc = site.getDescription();
        Boolean regionIdUpdateFlag = false;
        if (!VerifyUtil.isEmpty((String)site.getRegionId())) {
            regionIdUpdateFlag = this.isDistinctParam(site.getRegionId(), replica.getRegionId());
        }
        if (null != newName && !newName.equals(oldName)) {
            this.validateSiteName(newName);
            replica.setName(newName);
        }
        if (null != newDesc && !newDesc.equals(oldDesc)) {
            this.validateSiteDesc(newDesc);
            replica.setDescription(site.getDescription());
        }
        this.updateSiteDataBase(site, replica, oldName, newName, regionIdUpdateFlag);
    }

    private void updateSiteDataBase(Site site, Site replica, String oldName, String newName, Boolean regionIdUpdateFlag) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            if (!VerifyUtil.isEmpty((Object)session)) {
                transaction = session.beginTransaction();
                CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)replica);
                Query query = session.createQuery("update ProtectGroup pg set pg.productSiteName = ?0 where pg.productSiteName=?1");
                query.setParameter(0, (Object)newName);
                query.setParameter(1, (Object)oldName);
                query.executeUpdate();
                transaction.commit();
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("update site failed!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
                throw e;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    private void validateSiteName(String name) {
        if (!CommUtil.checkDrmNameParam((String)name)) {
            logger.error((Object)("name is illegal: " + name));
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isSiteExist(name)) {
            logger.error((Object)("name is repeated: " + name));
            throw new LegoCheckedException(1073947392L);
        }
    }

    private void validateSiteDesc(String desc) {
        if (!CommUtil.checkDrmDescParam((String)desc)) {
            logger.error((Object)("desc is illegal: " + desc));
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void deleteSite(String siteId) {
        Site site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        if (site == null) {
            throw new LegoCheckedException(201L);
        }
        OperationLock opLock = DeviceOperationLock.getLock((String)siteId);
        if (!opLock.tryLock()) {
            logger.warn((Object)("Someone[" + opLock.getOwnerName() + "] has locked site, siteId=" + siteId), 90160758784000L);
            throw new LegoCheckedException(102401L);
        }
        logger.info((Object)"Get site operation lock ... siteId=%s", new Object[]{siteId});
        try {
            this.checkSiteCanDelete(site);
            this.deleteSiteFromDB(site);
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"delete site set error", (Throwable)e, 90160758786872L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                opLock.unTryLock();
                logger.info((Object)"Release site operation lock ... siteId=%s", new Object[]{siteId});
                throw throwable;
            }
        }
        opLock.unTryLock();
        logger.info((Object)"Release site operation lock ... siteId=%s", new Object[]{siteId});
    }

    private void deleteSiteFromDB(Site site) {
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        baseDao.getHibernateTemplate().delete((Object)site);
    }

    public void checkSiteCanDelete(Site site) {
        String siteId = site.getSiteId();
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where siteId = ?", new Object[]{site.getSiteId()});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            logger.error((Object)"resources is empty.");
            throw new LegoCheckedException(1073947650L);
        }
        List pgReplicas = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ProtectGroupReplica where recoverySite = ?", (Object[])new String[]{siteId});
        if (!VerifyUtil.isEmpty((Collection)pgReplicas)) {
            throw new LegoCheckedException(1073947656L);
        }
        List pgs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ProtectGroup where productSiteId = ?", (Object[])new String[]{siteId});
        if (!VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)"pgs is empty.");
            throw new LegoCheckedException(1073947656L);
        }
        for (ISiteCheckService checkService : this.siteCheckServices) {
            checkService.checkCanDeleteSite(siteId);
        }
    }

    private Site getSite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("siteId=" + siteId), 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
        Site site = null;
        try {
            site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get site:" + siteId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return site;
    }

    private Site getSite(String siteId, String spiltLabel) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("siteId=" + siteId), 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
        Site site = null;
        ArrayList<String> siteIdSet = new ArrayList<String>();
        if (!VerifyUtil.isEmpty((String)spiltLabel)) {
            String[] sites = siteId.split(spiltLabel);
            if (sites.length >= 2) {
                for (String siteid : sites) {
                    siteIdSet.add(siteid);
                }
                site = this.getCombainSite(siteIdSet, spiltLabel);
            } else {
                site = this.getSite(siteId);
            }
            return site;
        }
        try {
            site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get site:" + siteId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return site;
    }

    private Site getCombainSite(List<String> siteIdSet, String spiltLabel) {
        Site site = null;
        StringBuffer name = new StringBuffer();
        for (String siteId : siteIdSet) {
            if (name.length() > 0) {
                name.append(spiltLabel);
            }
            if ((site = this.getSite(siteId)) == null) continue;
            name.append(site.getName());
        }
        if (null != site) {
            site.setName(name.toString());
        }
        return site;
    }

    private boolean isSiteExist(String name) {
        try {
            List siteList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site as st where st.name = ? and st.siteType = ?", new Object[]{name, 0});
            return !VerifyUtil.isEmpty((Collection)siteList);
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to get siteList:" + name), (Throwable)e, 90160758786876L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public Site getSiteById(String siteId, Long userId) {
        logger.debug((Object)"siteId=%s", new Object[]{siteId});
        Site site = this.getSite(siteId);
        if (site == null) {
            return null;
        }
        List filterSites = new ArrayList<Site>(1);
        filterSites.add(site);
        filterSites = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, filterSites);
        if (VerifyUtil.isEmpty(filterSites)) {
            return null;
        }
        return (Site)filterSites.get(0);
    }

    public Site getSiteById(String siteId) {
        logger.debug((Object)"siteId=%s", new Object[]{siteId});
        Site site = this.getSite(siteId);
        return site;
    }

    public Site getCombinaSiteById(String siteId, String spiltLabel) {
        Site site = this.getSite(siteId, spiltLabel);
        return site;
    }

    public BatchOperationResult checkResourceUsed(Long userId, List<Long> moIds) {
        logger.debug((Object)"moids=%s", new Object[]{moIds});
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        if (moIds == null || moIds.isEmpty()) {
            return batchOperationResult;
        }
        batchOperationResult.setTotalCount(moIds.size());
        BatchResultUtil.setBatchResult(batchOperationResult, moIds, userId);
        return batchOperationResult;
    }

    private void checkSiteParam(Site site) {
        if (site == null) {
            logger.error((Object)"site is null");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{site.getServerUuid(), site.getSiteId()});
    }

    public void onBind(ISiteCheckService checkService, Map<?, ?> properties) {
        logger.debug((Object)"onBind");
        if (checkService != null) {
            this.siteCheckServices.add(checkService);
        }
    }

    public void onUnbind(ISiteCheckService checkService, Map<?, ?> properties) {
        logger.debug((Object)"onUnbind");
        if (checkService != null) {
            this.siteCheckServices.remove(checkService);
        }
    }

    public List<Site> getAllLocalSites() {
        logger.debug((Object)"getAllLocalSites");
        String hql = "from Site as st where st.siteType = 0 order by st.name asc";
        return this.executeQuery(hql);
    }

    private List<Site> getAllSites() {
        logger.debug((Object)"getAllSites");
        String hql = "from Site as st order by st.name asc";
        return this.executeQuery(hql);
    }

    public List<Site> getAllSites(Long userId) {
        logger.debug((Object)"getAllSites");
        List<Site> siteList = this.getAllSites();
        if (VerifyUtil.isEmpty(siteList)) {
            return new ArrayList<Site>(0);
        }
        return ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, siteList);
    }

    private List<Site> executeQuery(String hql) {
        try {
            return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
            return new ArrayList<Site>();
        }
    }

    public Map<String, Integer> sum(String siteId, Long userId) {
        logger.debug((Object)"siteId=%s", new Object[]{siteId});
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Site site = null;
        try {
            site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unable to get site:" + siteId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        if (VerifyUtil.isEmpty((Object)site)) {
            return result;
        }
        for (String key : SiteResourceServiceProxy.getInstance().getAllSiteResourceServiceKey()) {
            if (!"ism.drm.deviceType.fusionsphere.mainType".equals(key)) continue;
            ISiteResourceService service = SiteResourceServiceProxy.getInstance().getSiteResourceService(key);
            result.put(key, service.sum(siteId, userId));
        }
        return result;
    }

    public List<? extends DrResource> getAllResourceBySite(String siteId, String resType) {
        logger.debug((Object)"siteId=%s, resType=%s", new Object[]{siteId, resType});
        if (siteId == null) {
            return new ArrayList();
        }
        return SiteResourceServiceProxy.getInstance().getSiteResourceService(resType).getDrResourceBySite(siteId);
    }

    public List<Site> getSites(String serverUuid) {
        if (VerifyUtil.isEmpty((String)serverUuid)) {
            logger.error((Object)("serverUuid=" + serverUuid), 90160758786873L);
            throw new LegoCheckedException(1073947393L);
        }
        List<Site> sites = null;
        try {
            List find = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site where serverUuid = ? order by name asc", (Object[])new String[]{serverUuid});
            sites = Arrays.asList(find.toArray(new Site[find.size()]));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Query site fail, serverUuid=" + serverUuid), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return sites;
    }

    public Site getSiteByDeviceSn(String devSn) {
        String hql = "from DrResource where deviceSn=?";
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        List resourceList = baseDao.getHibernateTemplate().find(hql, new Object[]{devSn});
        if (null == resourceList || resourceList.isEmpty()) {
            logger.error((Object)("DrResource is null, sn=" + devSn));
            throw new LegoCheckedException(2117645L);
        }
        DrResource drResource = (DrResource)resourceList.get(0);
        Site site = this.getSiteById(drResource.getSiteId());
        if (site == null) {
            logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(2117645L);
        }
        return site;
    }

    private Boolean isCloudSite(Site site) {
        return !VerifyUtil.isEmpty((Object)site.getIsCloudSite()) && site.getIsCloudSite() != false;
    }

    private Boolean isDistinctParam(Object param1, Object param2) {
        if (param1 != null && !param1.equals(param2)) {
            return true;
        }
        return false;
    }

    private Site getSitebyProjectId(String projectId) {
        try {
            List sites = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Site as st where st.projectId = ? ", new Object[]{projectId});
            if (VerifyUtil.isEmpty((Collection)sites)) {
                return null;
            }
            return (Site)sites.get(0);
        }
        catch (DataAccessException e) {
            logger.error((Object)("failed to get site:" + projectId), (Throwable)e, 0L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }
}

