/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.thirdservice.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AddressUtils;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.util.DiscoveryUtil;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService", desc="", interfaceClass=ICloudConfigService.class)
public class CloudConfigServiceImpl
extends BaseService
implements ICloudConfigService {
    private static final Log logger = LogFactory.getInstance(CloudConfigServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudConfig getCloudConfigBy(String configType) {
        Session session;
        CloudConfig result;
        block5: {
            result = null;
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria crit = session.createCriteria(CloudConfig.class);
                List ocAccessInfoList = crit.list();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)ocAccessInfoList)) break block5;
                for (CloudConfig ocAccessInfo : ocAccessInfoList) {
                    if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)ocAccessInfo) || !ocAccessInfo.getConfigType().equalsIgnoreCase(configType)) continue;
                    result = ocAccessInfo;
                    break;
                }
            }
            catch (DataAccessException e) {
                try {
                    logger.error((Object)("failed to query CloudConfig." + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    public void saveOrUpdateCloudConfig(CloudConfig info) {
        String domain = (String)info.getProps().get("manageOne_domain");
        String port = (String)info.getProps().get("manageOne_port");
        AddressUtils.checkInnerNetworkDetection(domain);
        if (!(com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)domain) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)port) || DiscoveryUtil.isSocketreachable((String)domain, (String)port))) {
            logger.error((Object)"The domain[%s]:[%s] is not reachable.", new Object[]{domain, port});
            throw new LegoCheckedException(1073947398L, new String[]{domain});
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)info);
    }

    public boolean checkArbitrationSwitchMode(String regionId) {
        String autoRecoveryValue;
        boolean result = true;
        CloudConfig config = this.getCloudConfigBy("system");
        if (config != null && config.getProps() != null && !VerifyUtil.isEmpty((String)(autoRecoveryValue = (String)config.getProps().get(regionId + "_" + "system_autorecovery")))) {
            result = Boolean.valueOf(autoRecoveryValue);
        }
        return result;
    }
}

