/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.thirdservice.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AddressUtils;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IOcAccessService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IOcParamListener;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service(name="com.huawei.ism.drm.system.thirdservice.sdk.service.IOcAccessService", desc="", interfaceClass=IOcAccessService.class)
public class OcAccessServiceImpl
extends BaseService
implements IOcAccessService {
    private static final Log logger = LogFactory.getInstance(OcAccessServiceImpl.class);
    private List<IOcParamListener> listener = new ArrayList<IOcParamListener>();

    public void onBind(IOcParamListener service, Map<String, String> properties) {
        if (service != null) {
            logger.info((Object)"service add successful");
            this.listener.add(service);
        }
    }

    public void onUnbind(IOcParamListener service, Map<String, String> properties) {
        if (service != null) {
            this.listener.remove(service);
            logger.info((Object)"onUnbind:%s", new Object[]{service.toString()});
        }
    }

    public void saveOrUpdateOcAccessInfo(CloudConfig info) {
        String pwd = (String)info.getProps().get("oc_password");
        if (!VerifyUtil.isEmpty((String)pwd)) {
            info.getProps().put("oc_password", WccEncryptor.encrypt((String)pwd));
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)info);
        for (IOcParamListener one : this.listener) {
            one.onChange();
        }
    }

    public String getOcToken(CloudConfig info, String hostIp, boolean isAllowInnerAddress) {
        if (!isAllowInnerAddress) {
            AddressUtils.checkInnerNetworkDetection((String)info.getProps().get("oc_domain"));
        }
        JSONObject message = new JSONObject();
        String userName = (String)info.getProps().get("oc_username");
        String passwd = (String)info.getProps().get("oc_password");
        message.put((Object)"userId", (Object)userName);
        message.put((Object)"value", (Object)passwd);
        if (VerifyUtil.isEmpty((String)hostIp) && VerifyUtil.isEmpty((String)(hostIp = LegoConfig.getInstance().getKeyValue("floatIp")))) {
            hostIp = LegoConfig.getInstance().getKeyValue("ip");
        }
        message.put((Object)"hostIp", (Object)hostIp);
        String requestMessage = message.toString();
        String url = "/v6.0/auth/tokens";
        String domain = (String)info.getProps().get("oc_domain");
        String port = (String)info.getProps().get("oc_port");
        RestClient client = new RestClient(domain, NumberUtil.parseInteger((Object)port).intValue(), null, null, (IResponseHandler)new OCResponseHandler(), new String[0]);
        String token = client.post(url, requestMessage, null);
        if (VerifyUtil.isEmpty((String)token)) {
            logger.error((Object)"query token error");
            return token;
        }
        JSONObject jsonObj = JSONObject.fromObject((Object)token);
        token = jsonObj.getString("data");
        return token;
    }

    static class OCResponseHandler
    implements IResponseHandler {
        private static final int REST_REQUEST_401_STATUS_CODE = 401;
        private static final int REST_REQUEST_200_STATUS_CODE = 200;

        OCResponseHandler() {
        }

        public void handleReponse(ServiceResponse response) {
            if (response == null) {
                logger.error((Object)"the reponse message is null.", 90160758787071L);
                throw new LegoCheckedException(1073947407L);
            }
            if (response.getStatusCode() == 401) {
                logger.error((Object)"Authentication failed, response code 401.");
                throw new LegoCheckedException(1073947691L);
            }
            if (null != response.getContentData() && response.getStatusCode() != 200) {
                logger.error((Object)"Get ocToken error,response code:%s, response:%s.", new Object[]{response.getStatusCode(), response.getResponseString()});
                JSONObject result = JSONObject.fromObject((Object)response.getResponseString());
                logger.error((Object)"get data from oc error: %s", new Object[]{result.get("exceptionId")});
                throw new LegoCheckedException(1073947407L);
            }
        }
    }
}

