/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.sdk.bo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.io.Serializable;

public class PolicyBO
implements Serializable {
    private static final long serialVersionUID = 8424653852215234275L;
    @JsonProperty(value="period_type")
    private String periodType;
    @JsonProperty(value="period_interval")
    private String periodInterval;
    @JsonProperty(value="time_point")
    private String timePoint;

    public String getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public String getPeriodInterval() {
        return this.periodInterval;
    }

    public void setPeriodInterval(String periodInterval) {
        this.periodInterval = periodInterval;
    }

    public String getTimePoint() {
        return this.timePoint;
    }

    public void setTimePoint(String timePoint) {
        this.timePoint = timePoint;
    }

    public void validate() {
        int interVal = this.parsePeriodInterval();
        if ("day".equals(this.periodType)) {
            if (interVal < 1 || interVal > 31) {
                throw new LegoCheckedException(1073947393L, "periodInterval is not in [1,31].");
            }
            if (!CommUtil.checkTimeParam((String)this.timePoint)) {
                throw new LegoCheckedException(1073947393L, "timePoint is not right.");
            }
        } else if ("hour".equals(this.periodType)) {
            if (interVal < 1 || interVal > 23) {
                throw new LegoCheckedException(1073947393L, "periodInterval is not in [1,23].");
            }
        } else if ("minute".equals(this.periodType)) {
            if (interVal < 5 || interVal > 59) {
                throw new LegoCheckedException(1073947393L, "periodInterval is not in [5,59].");
            }
        } else {
            throw new LegoCheckedException(1073947393L, "periodType is not supported.");
        }
    }

    private int parsePeriodInterval() {
        if (null == this.periodInterval || this.periodInterval.isEmpty()) {
            throw new LegoCheckedException(1073947393L, "periodInterval is empty.");
        }
        try {
            return Integer.parseInt(this.periodInterval);
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(1073947393L, "recoveryType is invalid:" + this.periodInterval, (Throwable)e);
        }
    }
}

