/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OpenStackAvailabilityZoneMapping
extends ManagedObject {
    private static final long serialVersionUID = 2836013793190053660L;
    private static final Log LOG = LogFactory.getInstance(OpenStackAvailabilityZoneMapping.class);
    @JsonProperty(value="az_pair_id")
    private Long moId;
    @JsonProperty(value="primary_az_id")
    private String primaryAzId;
    @JsonProperty(value="primary_az")
    private String primaryAz;
    @JsonProperty(value="second_az_id")
    private String secondAzId;
    @JsonProperty(value="second_az")
    private String secondAz;
    @JsonProperty(value="primary_region_id")
    private String primaryRegionId;
    @JsonProperty(value="primary_region")
    private String primaryRegion;
    @JsonProperty(value="second_region_id")
    private String secondRegionId;
    @JsonProperty(value="second_region")
    private String secondRegion;
    @JsonProperty(value="object_type")
    private String objectType = ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue();

    public String getPrimaryAzId() {
        return this.primaryAzId;
    }

    public void setPrimaryAzId(String primaryAzId) {
        this.primaryAzId = primaryAzId;
    }

    public String getSecondAzId() {
        return this.secondAzId;
    }

    public void setSecondAzId(String secondAzId) {
        this.secondAzId = secondAzId;
    }

    public String getPrimaryAz() {
        return this.primaryAz;
    }

    public void setPrimaryAz(String primaryAz) {
        this.primaryAz = primaryAz;
    }

    public String getSecondAz() {
        return this.secondAz;
    }

    public void setSecondAz(String secondAz) {
        this.secondAz = secondAz;
    }

    public String getPrimaryRegion() {
        return this.primaryRegion;
    }

    public void setPrimaryRegion(String primaryRegion) {
        this.primaryRegion = primaryRegion;
    }

    public void setPrimaryRegionId(String primaryRegionId) {
        this.primaryRegionId = primaryRegionId;
    }

    public String getPrimaryRegionId() {
        return this.primaryRegionId;
    }

    public String getSecondRegion() {
        return this.secondRegion;
    }

    public void setSecondRegion(String secondRegion) {
        this.secondRegion = secondRegion;
    }

    public void setSecondRegionId(String secondRegionId) {
        this.secondRegionId = secondRegionId;
    }

    public String getSecondRegionId() {
        return this.secondRegionId;
    }

    public Long getMoId() {
        return this.moId;
    }

    public void setMoId(Long moId) {
        this.moId = moId;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public boolean checkAZObject() {
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)super.getType()) == ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA) {
            return OpenStackAvailabilityZoneMapping.checkRegionAzId(this.primaryAzId) && OpenStackAvailabilityZoneMapping.checkRegionAzName(this.primaryAz);
        }
        return OpenStackAvailabilityZoneMapping.checkRegionAzId(this.primaryAzId) && OpenStackAvailabilityZoneMapping.checkRegionAzName(this.primaryAz) && OpenStackAvailabilityZoneMapping.checkRegionAzId(this.secondAzId) && OpenStackAvailabilityZoneMapping.checkRegionAzName(this.secondAz);
    }

    public boolean checkRegionObject() {
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)super.getType()) == ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA) {
            return OpenStackAvailabilityZoneMapping.checkRegionAzId(this.primaryRegionId) && OpenStackAvailabilityZoneMapping.checkRegionAzName(this.primaryRegion);
        }
        return OpenStackAvailabilityZoneMapping.checkRegionAzId(this.primaryRegionId) && OpenStackAvailabilityZoneMapping.checkRegionAzName(this.primaryRegion) && OpenStackAvailabilityZoneMapping.checkRegionAzId(this.secondRegionId) && OpenStackAvailabilityZoneMapping.checkRegionAzName(this.secondRegion);
    }

    private static boolean checkRegionAzId(String id) {
        return !VerifyUtil.isEmpty((String)id) && ParamChecker.checkGeneralId((String)id);
    }

    private static boolean checkRegionAzName(String name) {
        return !VerifyUtil.isEmpty((String)name) && ParamChecker.checkGeneralText((String)name);
    }

    public static boolean checkObjectRepeatFromDB(OpenStackAvailabilityZoneMapping mapping, List<OpenStackAvailabilityZoneMapping> mappingsFromDB) {
        if (VerifyUtil.isEmpty((Object)((Object)mapping)) || VerifyUtil.isEmpty((String)mapping.getType())) {
            LOG.error((Object)"Mapping is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(mappingsFromDB)) {
            return false;
        }
        for (OpenStackAvailabilityZoneMapping mappingFromDB : mappingsFromDB) {
            if (!OpenStackAvailabilityZoneMapping.compareMappingAndMappingFromDB(mapping, mappingFromDB)) continue;
            return true;
        }
        return false;
    }

    private static boolean compareMappingAndMappingFromDB(OpenStackAvailabilityZoneMapping mapping, OpenStackAvailabilityZoneMapping mappingFromDB) {
        if (mapping.getType().toLowerCase(Locale.US).equals(mappingFromDB.getType().toLowerCase(Locale.US)) && ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)mappingFromDB.getType()) == ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO) {
            if (OpenStackAvailabilityZoneMapping.isAZExistInDB(mapping, mappingFromDB)) {
                LOG.debug((Object)"There is a same az id in DB.", 90160758786989L);
                return true;
            }
        } else if (mapping.getType().toLowerCase(Locale.US).equals(mappingFromDB.getType().toLowerCase(Locale.US)) && ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)mappingFromDB.getType()) == ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION) {
            if (OpenStackAvailabilityZoneMapping.isExistSameRegionAZInDB(mapping, mappingFromDB) || OpenStackAvailabilityZoneMapping.isExistSameRegionAZPairInDB(mapping, mappingFromDB)) {
                LOG.debug((Object)"There is a same az id or region id in DB.", 90160758786989L);
                return true;
            }
        } else if (mapping.getType().toLowerCase(Locale.US).equals(mappingFromDB.getType().toLowerCase(Locale.US)) && ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.equals((Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)mappingFromDB.getType())) && mapping.getPrimaryAzId().equals(mappingFromDB.getPrimaryAzId()) && mapping.getPrimaryRegionId().equals(mappingFromDB.getPrimaryRegionId())) {
            LOG.debug((Object)"There is a same az id and region id in DB.", 90160758786989L);
            return true;
        }
        return false;
    }

    private static boolean isAZExistInDB(OpenStackAvailabilityZoneMapping map, OpenStackAvailabilityZoneMapping mappingFromDB) {
        boolean azExist;
        boolean bl = azExist = map.getPrimaryAzId().equals(mappingFromDB.getPrimaryAzId()) || map.getPrimaryAzId().equals(mappingFromDB.getSecondAzId()) || map.getSecondAzId().equals(mappingFromDB.getPrimaryAzId()) || map.getSecondAzId().equals(mappingFromDB.getSecondAzId());
        if (null == map.getPrimaryRegionId() || null == mappingFromDB.getPrimaryRegionId()) {
            return azExist;
        }
        if (map.getPrimaryRegionId().equals(mappingFromDB.getPrimaryRegionId())) {
            return azExist;
        }
        return false;
    }

    public static boolean isExistSameRegionAZInDB(OpenStackAvailabilityZoneMapping map, OpenStackAvailabilityZoneMapping mappingFromDB) {
        return map.getPrimaryRegionId().equals(mappingFromDB.getPrimaryRegionId()) && map.getSecondRegionId().equals(mappingFromDB.getSecondRegionId()) && map.getPrimaryAzId().equals(mappingFromDB.getPrimaryAzId()) && map.getSecondAzId().equals(mappingFromDB.getSecondAzId());
    }

    private static boolean isExistSameRegionAZPairInDB(OpenStackAvailabilityZoneMapping map, OpenStackAvailabilityZoneMapping mappingFromDB) {
        return map.getPrimaryRegionId().equals(mappingFromDB.getSecondRegionId()) && map.getSecondRegionId().equals(mappingFromDB.getPrimaryRegionId()) && map.getPrimaryAzId().equals(mappingFromDB.getSecondAzId()) && map.getSecondAzId().equals(mappingFromDB.getPrimaryAzId());
    }

    public static boolean checkObjectRepeat(OpenStackAvailabilityZoneMapping mapping) {
        if (VerifyUtil.isEmpty((Object)((Object)mapping)) || VerifyUtil.isEmpty((String)mapping.getType())) {
            LOG.error((Object)"Mapping is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)mapping.getType()) == ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO) {
            return mapping.secondAzId.equals(mapping.primaryAzId);
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)mapping.getType()) == ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION) {
            return mapping.primaryRegionId.equals(mapping.secondRegionId);
        }
        return false;
    }

    public static boolean isTypeExist(String type) {
        if (VerifyUtil.isEmpty((String)type)) {
            LOG.error((Object)"Type is empty.", 90160758786989L);
            return false;
        }
        return null != ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)type);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("az_pair_id", this.moId);
        map.put("primary_region_id", this.primaryRegionId);
        map.put("primary_region", this.primaryRegion);
        map.put("second_region_id", this.secondRegionId);
        map.put("second_region", this.secondRegion);
        map.put("primary_az_id", this.primaryAzId);
        map.put("primary_az", this.primaryAz);
        map.put("second_az_id", this.secondAzId);
        map.put("second_az", this.secondAz);
        map.put("object_type", VerifyUtil.isEmpty((String)this.objectType) ? ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue() : this.objectType);
        ServiceInstaceEnumDefine.ServiceInstanceTypeE type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)super.getType());
        if (null != type) {
            map.put("type", type.getFrontValue());
        } else {
            map.put("type", super.getType());
        }
        return map;
    }
}

