/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs;

import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.AddVolumeToVmRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.bo.DelVolumeFromVmRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.RedirectRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddVolumeToVmRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.ThrowableSupplier;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VmInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRepicaAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public abstract class FeatureRestService
extends RedirectRestService {
    private static final Log logger = LogFactory.getInstance(FeatureRestService.class);

    public abstract Response queryAzPairs(String var1);

    public abstract Response createServiceInstanceQuotasBudget(String var1, CreateInstanceRequest var2) throws RestException;

    public abstract Response createServiceInstance(String var1, BcsCreateInstanceRequest var2) throws RestException;

    public abstract Response addServerQuotasBudget(String var1, String var2, AddServersRequest var3) throws RestException;

    public abstract Response addServer(String var1, String var2, BcsAddServersRequest var3) throws RestException;

    protected abstract JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO var1, List<QuotaResourcesBo> var2);

    public Response addVolumeToVmQuotasBudget(String projectId, String instanceId, String serverId, AddVolumeToVmRequest request) throws RestException {
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> addVolsSet;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + ",serverId is " + serverId + "," + (null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        List<VolumeBO> addVolList = request.getAddVols();
        Response respAddVol = this.dealAddVol(addVolList, addVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respAddVol) {
            return respAddVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            VmInfoBO vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)vmInfoBO.getName());
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serverId);
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().checkAddVolumeParamAndCalQuota(projectId, instanceId, serverId, addVolsSet, extendParam);
            JSONObject returnJson = new JSONObject();
            JSONArray array = this.constructAddVolumeToVmQuotasBudget(instanceInfoBO, list);
            returnJson.put((Object)"quotas", (Object)array);
            logger.debug((Object)"AddVolumeToVmQuotasBudget: %s", new Object[]{array});
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addVolumeToVmQuotasBudget failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addVolumeToVmQuotasBudget failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response addVolumeToVm(String projectId, String instanceId, String serverId, BcsAddVolumeToVmRequest request) throws RestException {
        VmInfoBO vmInfoBO;
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> addVolsSet;
        String reqId = this.recordRequestLog("Projectid is " + projectId + ",instanceId is " + instanceId + ",serverId is " + serverId + "," + (null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        if (!ParamChecker.checkGeneralId((String)request.getSubscriptionId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        List<VolumeBO> addVolList = request.getAddVols();
        Response respAddVol = this.dealAddVol(addVolList, addVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respAddVol) {
            return respAddVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)vmInfoBO.getName());
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serverId);
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            extendParam.setEvsQuota(this.getEvsQuotaFromResponseForReportOrder(() -> this.addVolumeToVmQuotasBudget(projectId, instanceId, serverId, request)));
            String taskId = this.getInstanceService().addVolumesToVm(projectId, instanceId, serverId, addVolsSet, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.writeSuccLog(reqId, vmInfoBO, instanceInfoBO, taskId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addVolumeToVm failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addVolumeToVm failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private void writeSuccLog(String reqId, VmInfoBO vmInfoBO, InstanceInfoBO instanceInfoBO, String taskId) {
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "Accept request. task_id is " + taskId + ".");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
    }

    protected Response dealAddVol(List<VolumeBO> addVolList, Set<ProtectedVolumeInfo> addVolsSet, String reqId) throws RestException {
        if (VerifyUtil.isEmpty(addVolList)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The add_vols parameter is empty.");
        }
        if (addVolList.size() > 60) {
            return this.wrong(Response.Status.BAD_REQUEST, "volumes is more than 60");
        }
        for (VolumeBO bo : addVolList) {
            if (!this.validateVolumeParam(bo)) {
                return this.wrong(Response.Status.BAD_REQUEST, "VolumeBO isn't fulfilled.");
            }
            ProtectedVolumeInfo po = new ProtectedVolumeInfo();
            po.setDrVolumeType(bo.getDrVolumeType());
            po.setVolumeId(bo.getVolumeId());
            po.setVolumeType(bo.getVolumeType());
            addVolsSet.add(po);
        }
        return null;
    }

    protected abstract boolean validateVolumeParam(VolumeBO var1);

    public Response deleteServiceInstanceCheck(String projectId, String instanceId) throws RestException {
        String reqId = this.recordRequestLog("ProjectId is " + projectId + "instanceId is " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        try {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServiceInstanceCheck failed.");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            String result = this.getInstanceService().deleteServiceInstance(projectId, instanceId, extendParam);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServiceInstanceCheck failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"deleteServiceInstanceCheck failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response deleteServiceInstance(String projectId, String instanceId, String subscriptionId) throws RestException {
        String reqId = this.recordRequestLog("projectId is " + projectId + "instanceId is " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        try {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            String taskId = this.getInstanceService().deleteServiceInstance(projectId, instanceId, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "Accept request. task_id is " + taskId + ".");
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"deleteServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response deleteServersCheck(String projectId, String instanceId, List<String> serverIds) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("ProjectId is " + projectId + ",instanceId is " + instanceId + "serverIds is " + serverIds);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (VerifyUtil.isEmpty(serverIds)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Server_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "server_id is empty.");
        }
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            for (String serverId : serverIds) {
                VmInfoBO vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
                nameList.add(vmInfoBO.getName());
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)((Object)nameList).toString());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServersCheck failed.");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            String result = this.getInstanceService().deleteServerInServiceInstance(projectId, instanceId, new HashSet<String>(serverIds), extendParam);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServersCheck failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"deleteServersCheck failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response deleteServers(String projectId, String instanceId, List<String> serverIds, String subscriptionId) throws RestException {
        String reqId = this.recordRequestLog("ProjectId is " + projectId + ",instanceId is " + instanceId + "serverId is " + serverIds);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty(serverIds)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is empty.");
        }
        if (serverIds.size() > 256) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id in request is more than 256");
        }
        for (String serverId : serverIds) {
            if (VerifyUtil.isEmpty((String)serverId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "server_id is empty.");
            }
            if (ParamChecker.checkGeneralId((String)serverId)) continue;
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is incorrect.");
        }
        ArrayList<String> nameList = new ArrayList<String>();
        InstanceInfoBO instanceInfoBO = this.getInstanceInfoBO(projectId, instanceId, serverIds, nameList);
        try {
            String taskId = this.getTaskId(projectId, instanceId, serverIds, subscriptionId);
            this.writeSuccLog(reqId, instanceInfoBO, nameList, taskId);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServers failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"deleteServers failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private String getTaskId(String projectId, String instanceId, List<String> serverIds, String subscriptionId) {
        ExtendParamInfo extendParam = new ExtendParamInfo();
        extendParam.setSubscriptionId(subscriptionId);
        return this.getInstanceService().deleteServerInServiceInstance(projectId, instanceId, new HashSet<String>(serverIds), extendParam);
    }

    private void writeSuccLog(String reqId, InstanceInfoBO instanceInfoBO, List<String> nameList, String taskId) {
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
    }

    private InstanceInfoBO getInstanceInfoBO(String projectId, String instanceId, List<String> serverIds, List<String> nameList) {
        InstanceInfoBO instanceInfoBO;
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            for (String serverId : serverIds) {
                VmInfoBO vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
                nameList.add(vmInfoBO.getName());
            }
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)nameList.toString());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"getInstanceInfoBO failed.");
            throw e;
        }
        return instanceInfoBO;
    }

    public Response delVolumeFromVmCheck(String projectId, String instanceId, String serverId, DelVolumeFromVmRequest request) throws RestException {
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> delVolsSet;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + ",serverId is " + serverId + (null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        List<String> delVolList = request.getDelVols();
        Response respDelVol = this.dealDelVols(delVolList, delVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respDelVol) {
            return respDelVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            VmInfoBO vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)vmInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"delVolumeFromVmCheck failed.");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            String result = this.getInstanceService().delVolumesFromVm(projectId, instanceId, serverId, delVolsSet, extendParam);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"delVolumeFromVmCheck failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"delVolumeFromVmCheck failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public Response delVolumeFromVm(String projectId, String instanceId, String serverId, DelVolumeFromVmRequest request, String subscriptionId) throws RestException {
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> delVolsSet;
        String reqId = this.recordRequestLog(String.format(Locale.ENGLISH, "projectid is %s,, instanceId is %s, serverId is %s, %s", projectId, instanceId, serverId, null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        List<String> delVolList = request.getDelVols();
        Response respDelVol = this.dealDelVols(delVolList, delVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respDelVol) {
            return respDelVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            VmInfoBO vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)vmInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serverId);
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            String taskId = this.getInstanceService().delVolumesFromVm(projectId, instanceId, serverId, delVolsSet, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"delVolumeFromVm failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"delVolumeFromVm failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    protected Response checkParameters(String projectId, String instanceId, String serverId, Object request, String reqId) throws RestException {
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)serverId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)serverId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "server_id is incorrect.");
        }
        if (request == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "requestBO is empty.");
        }
        return null;
    }

    protected Response dealDelVols(List<String> delVolList, Set<ProtectedVolumeInfo> delVolsSet, String reqId) throws RestException {
        if (VerifyUtil.isEmpty(delVolList)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The del_vols parameter is empty.");
        }
        if (delVolList.size() > 60) {
            return this.wrong(Response.Status.BAD_REQUEST, "volumes is more than 60");
        }
        for (String volumeId : delVolList) {
            if (VerifyUtil.isEmpty((String)volumeId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "VolumeId is empty.");
            }
            if (!ParamChecker.checkGeneralId((String)volumeId)) {
                return this.wrong(Response.Status.BAD_REQUEST, "VolumeId is incorrect.");
            }
            ProtectedVolumeInfo po = new ProtectedVolumeInfo();
            po.setVolumeId(volumeId);
            delVolsSet.add(po);
        }
        return null;
    }

    public abstract Response downgradeServiceInstanceCheck(String var1, String var2, String var3, String var4) throws RestException;

    public Response downgradeServiceInstance(String projectId, String instanceId, String instanceType, String subscriptionId, String productId) throws RestException {
        return null;
    }

    public Response upgradeServiceInstance(BcsCreateInstanceRequest request, boolean isCheck) {
        return null;
    }

    public Response upgradeServerQuotasBudget(BcsCreateInstanceRequest request) {
        return null;
    }

    public Response queryAvailableOsPlaceholderServers(String instanceType, String serverId, String projectId, String remoteProjectId, OpenStackAvailabilityZoneMapping zoneMapping) throws RestException {
        String regionId = zoneMapping.getPrimaryRegionId();
        String remoteRegionId = zoneMapping.getSecondRegionId();
        String remoteAzName = zoneMapping.getSecondAzId();
        this.recordRequestLog("projectId:" + projectId + ",serverId:" + serverId + ",regionId:" + regionId + ",remoteRegionId:" + remoteRegionId + ",remoteAzName:" + remoteAzName);
        List vms = this.getInstanceService().queryAvailableOccupiedVms(instanceType, serverId, projectId, remoteProjectId, zoneMapping);
        JSONArray result = new JSONArray();
        for (VmInfoBO vm : vms) {
            result.add((Object)this.getPlaceHoldVmJsonObject(vm));
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"servers", (Object)result);
        return this.getResponse(Response.Status.OK, returnJson);
    }

    public Response queryProtectableServers(String projectId, String regionId, String availableZone, String instanceType, String instanceID) throws RestException {
        ServiceInstaceEnumDefine.ServiceInstanceTypeE type;
        Response resultResponse = this.checkParamForProtectableServers(projectId, regionId, availableZone, instanceType);
        if (resultResponse != null) {
            return resultResponse;
        }
        List protectedServiceIdList = null;
        if (!VerifyUtil.isEmpty((String)instanceID)) {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceID, null);
            protectedServiceIdList = instanceInfoBO.getServers();
        }
        if ((type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)instanceType)) == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is incorrect.");
        }
        List vms = this.getInstanceService().queryAvailableVms(type.getValue(), projectId, regionId, availableZone, protectedServiceIdList);
        JSONArray result = new JSONArray();
        for (VmInfoBO vm : vms) {
            JSONObject obj = this.getProtectAbleVmJsonObject(vm);
            result.add((Object)obj);
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"servers", (Object)result);
        return this.getResponse(Response.Status.OK, returnJson);
    }

    public Response queryAllServers(String projectId, String regionId, String availableZone) throws RestException {
        List vms = this.getInstanceService().queryAllAvailableVms(projectId, regionId, availableZone);
        JSONArray result = new JSONArray();
        for (VmInfoBO vm : vms) {
            JSONObject obj = this.getProtectAbleVmJsonObject(vm);
            result.add((Object)obj);
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"servers", (Object)result);
        return this.getResponse(Response.Status.OK, returnJson);
    }

    protected Response checkParamForProtectableServers(String projectId, String regionId, String availableZone, String instanceType) throws RestException {
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)regionId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "regionId is empty.");
        }
        if (VerifyUtil.isEmpty((String)availableZone)) {
            return this.wrong(Response.Status.BAD_REQUEST, "remoteRegionId is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is empty.");
        }
        return null;
    }

    protected JSONObject getProtectAbleVmJsonObject(VmInfoBO vm) {
        JSONObject jsonObject = this.getPlaceHoldVmJsonObject(vm);
        jsonObject.put((Object)"vm_status", (Object)vm.getVmStatus());
        jsonObject.put((Object)"storage_sn", (Object)vm.getStorageSn());
        jsonObject.put((Object)"tags", (Object)vm.getTags());
        jsonObject.put((Object)"description", (Object)vm.getDescription());
        return jsonObject;
    }

    protected JSONObject getPlaceHoldVmJsonObject(VmInfoBO vm) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"server_id", (Object)vm.getServerId());
        obj.put((Object)"name", (Object)vm.getName());
        obj.put((Object)"ip_address", (Object)vm.getIp());
        obj.put((Object)"ipv6_address", (Object)vm.getIpv6());
        JSONObject flavor = new JSONObject();
        flavor.put((Object)"ram", (Object)vm.getRam());
        flavor.put((Object)"cpu_count", (Object)vm.getCpu());
        obj.put((Object)"flavor", (Object)flavor);
        return obj;
    }

    public Response queryAzPairs(String regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE type) {
        List mappings = this.getOpenstackResourceService().getAZMappingsByObjectType(ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue());
        ArrayList<Map<String, Object>> maps = new ArrayList();
        if (type == ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION || type == ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION) {
            maps = this.getOpenstackResourceService().getVHACSDRMapping(regionId, type);
            this.deleteRepeatAZMap(maps);
        } else {
            this.getAZMap(mappings, regionId, type, maps);
        }
        ArrayList<OpenStackRepicaAvailabilityZone.RegionInfo> regionPairs = new ArrayList<OpenStackRepicaAvailabilityZone.RegionInfo>();
        boolean isAddSucc = false;
        for (int i = 0; i < maps.size(); ++i) {
            Map item = (Map)maps.get(i);
            if (item == null) {
                throw new LegoCheckedException(0x300001L);
            }
            for (int j = 0; j < regionPairs.size(); ++j) {
                isAddSucc = false;
                OpenStackRepicaAvailabilityZone.RegionInfo regionPair = (OpenStackRepicaAvailabilityZone.RegionInfo)regionPairs.get(j);
                if (regionPair == null) {
                    throw new LegoCheckedException(0x300001L);
                }
                String primaryRegionId = regionPair.getPrimaryRegion().getRegionId();
                String secondRegionId = regionPair.getSecondRegion().getRegionId();
                if (primaryRegionId != null && secondRegionId != null && (isAddSucc = this.sameAZInSameRegion(j, regionPairs, item, type))) break;
            }
            if (!isAddSucc && ((String)item.get("primary_region_id")).equals(regionId)) {
                this.getAZMap(item, regionPairs, true, type);
                continue;
            }
            if (isAddSucc || !((String)item.get("second_region_id")).equals(regionId)) continue;
            this.getAZMap(item, regionPairs, true, type);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"region_pairs", regionPairs);
        return Response.ok().entity((Object)jsonObject.toString()).build();
    }

    protected void getAZMap(List<OpenStackAvailabilityZoneMapping> mappings, String regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE type, List<Map<String, Object>> maps) {
        for (OpenStackAvailabilityZoneMapping mapping : mappings) {
            if (type != ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)mapping.getType()) || regionId != null && !this.isRelatedAZMapping(mapping, regionId)) continue;
            Map map = mapping.toMap();
            map.put("primary_region_name", map.get("primary_region"));
            map.put("second_region_name", map.get("second_region"));
            map.put("primary_az_name", map.get("primary_az"));
            map.put("second_az_name", map.get("second_az"));
            map.remove("primary_region");
            map.remove("second_region");
            map.remove("primary_az");
            map.remove("second_az");
            map.remove("type");
            maps.add(map);
        }
    }

    private boolean isRelatedAZMapping(OpenStackAvailabilityZoneMapping mapping, String regionId) {
        if (mapping == null || regionId == null) {
            return false;
        }
        if (regionId.equals(mapping.getPrimaryRegionId())) {
            return true;
        }
        return regionId.equals(mapping.getSecondRegionId());
    }

    protected OpenStackAvailabilityZoneMapping initOpenStackAvailabilityZoneMapping(String regionId, String remoteRegionId, String remoteAzName) {
        OpenStackAvailabilityZoneMapping zoneMapping = new OpenStackAvailabilityZoneMapping();
        zoneMapping.setPrimaryRegionId(regionId);
        zoneMapping.setSecondRegionId(remoteRegionId);
        zoneMapping.setSecondAzId(remoteAzName);
        zoneMapping.setSecondAz(remoteAzName);
        return zoneMapping;
    }

    protected JSONArray constructQuotaResult(String type, String projectId, String regionId, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        JSONArray quotaResourceList = new JSONArray();
        for (QuotaResourcesBo bo : list) {
            if ("gigabytes".equals(bo.getType()) || "volumes".equals(bo.getType())) continue;
            JSONObject quotaResource = new JSONObject();
            quotaResource.put((Object)"resource", (Object)bo.getType());
            quotaResource.put((Object)"used", (Object)Float.valueOf(bo.getQuota()));
            quotaResourceList.add((Object)quotaResource);
        }
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.getServiceIdFromServiceType((String)type));
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        JSONArray quotas = new JSONArray();
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)projectId);
        quota.put((Object)"region_id", (Object)regionId);
        quota.put((Object)"usages", (Object)usagesList);
        quotas.add((Object)quota);
        if (null != drProjectId) {
            JSONObject drQuota = new JSONObject();
            drQuota.put((Object)"project_id", (Object)drProjectId);
            drQuota.put((Object)"region_id", (Object)drRegionId);
            drQuota.put((Object)"usages", (Object)usagesList);
            quotas.add((Object)drQuota);
        }
        return quotas;
    }

    protected JSONObject constructEvsQuota(String drAzid, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        float size = 0.0f;
        float num = 0.0f;
        float drvolSize = 0.0f;
        float drvolNum = 0.0f;
        float cshaDrvolSize = 0.0f;
        float cshaDrvolNum = 0.0f;
        IQuotaService service = (IQuotaService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IQuotaService.class.getName(), IQuotaService.class);
        String evsId = service.getEVSServiceId();
        logger.debug((Object)"EVSServiceId is: %s", new Object[]{evsId});
        List volTypeMappings = ((IOpenstackResourceService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IOpenstackResourceService.class.getName(), IOpenstackResourceService.class)).getVolTypeMappingsFromDB();
        HashMap<String, Float> volumeSizeGroupByTypeMap = new HashMap<String, Float>();
        for (QuotaResourcesBo bo : list) {
            String resourceId = service.getResourceIdFromQuotaResources(volTypeMappings, drRegionId, drAzid, bo);
            float volumeSizeGroupByType = volumeSizeGroupByTypeMap.getOrDefault(resourceId, Float.valueOf(0.0f)).floatValue();
            if (bo.getType().endsWith("vol.size")) {
                size += bo.getQuota();
                volumeSizeGroupByType += bo.getQuota();
            } else if (bo.getType().endsWith("vol.num")) {
                num += bo.getQuota();
            } else if ("volumes".equals(bo.getType())) {
                drvolNum = bo.getQuota();
            } else if ("gigabytes".equals(bo.getType())) {
                drvolSize = bo.getQuota();
                volumeSizeGroupByType -= bo.getQuota();
            } else if ("csha_volumes".equals(bo.getType())) {
                cshaDrvolNum = bo.getQuota();
            } else if ("csha_gigabytes".equals(bo.getType())) {
                cshaDrvolSize = bo.getQuota();
                volumeSizeGroupByType -= bo.getQuota();
            }
            volumeSizeGroupByTypeMap.put(resourceId, Float.valueOf(volumeSizeGroupByType));
        }
        JSONArray quotaResourceList = new JSONArray();
        this.updateEvsVolSize(size, drvolSize, cshaDrvolSize, volumeSizeGroupByTypeMap, quotaResourceList);
        JSONObject numResource = new JSONObject();
        numResource.put((Object)"resource", (Object)"volumes");
        numResource.put((Object)"used", (Object)Float.valueOf(num - Math.max(drvolNum, cshaDrvolNum)));
        quotaResourceList.add((Object)numResource);
        JSONArray usagesList = this.getUsagesList(drAzid, evsId, quotaResourceList);
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)drProjectId);
        quota.put((Object)"region_id", (Object)drRegionId);
        quota.put((Object)"usages", (Object)usagesList);
        return quota;
    }

    private JSONArray getUsagesList(String drAzid, String evsId, JSONArray quotaResourceList) {
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)evsId);
        usage.put((Object)"available_zone", (Object)this.getIdFromUuid(drAzid));
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        return usagesList;
    }

    private void updateEvsVolSize(float size, float drvolSize, float cshaDrvolSize, Map<String, Float> volumeSizeGroupByTypeMap, JSONArray quotaResourceList) {
        JSONObject sizeResource = new JSONObject();
        sizeResource.put((Object)"resource", (Object)"gigabytes");
        sizeResource.put((Object)"used", (Object)Float.valueOf(size - Math.max(drvolSize, cshaDrvolSize)));
        quotaResourceList.add((Object)sizeResource);
        volumeSizeGroupByTypeMap.forEach((key, value) -> {
            if (key.equals("gigabytes")) {
                return;
            }
            JSONObject volumeTypeResource = new JSONObject();
            volumeTypeResource.put((Object)"resource", key);
            volumeTypeResource.put((Object)"used", value);
            quotaResourceList.add((Object)volumeTypeResource);
        });
    }

    public String getIdFromUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return null;
        }
        if (uuid.contains(":")) {
            uuid = uuid.split(":")[1];
        }
        return uuid;
    }

    public abstract ServiceInstaceEnumDefine.ServiceInstanceTypeE getInstanceType();

    protected void getAZMap(Map<String, Object> item, List<OpenStackRepicaAvailabilityZone.RegionInfo> regionPairs, boolean reverseAZ, ServiceInstaceEnumDefine.ServiceInstanceTypeE type) {
        OpenStackRepicaAvailabilityZone.Az azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
        OpenStackRepicaAvailabilityZone.AzPair azPair = new OpenStackRepicaAvailabilityZone.AzPair();
        ArrayList<OpenStackRepicaAvailabilityZone.AzPair> azPairs = new ArrayList<OpenStackRepicaAvailabilityZone.AzPair>();
        azNameAndId.setAzId(reverseAZ ? (String)item.get("primary_az_id") : (String)item.get("second_az_id"));
        azNameAndId.setAzName(reverseAZ ? (String)item.get("primary_az_name") : (String)item.get("second_az_name"));
        azPair.setPrimaryAz(azNameAndId);
        azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
        azNameAndId.setAzId(reverseAZ ? (String)item.get("second_az_id") : (String)item.get("primary_az_id"));
        azNameAndId.setAzName(reverseAZ ? (String)item.get("second_az_name") : (String)item.get("primary_az_name"));
        azPair.setSecondAz(azNameAndId);
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.equals((Object)type)) {
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            azNameAndId.setAzId((String)item.get("dr_second_az_id"));
            azNameAndId.setAzName((String)item.get("dr_second_az_name"));
            azPair.setDrRregionSsecondAz(azNameAndId);
        }
        azPairs.add(azPair);
        OpenStackRepicaAvailabilityZone.Region region = new OpenStackRepicaAvailabilityZone.Region();
        OpenStackRepicaAvailabilityZone.RegionInfo regionInfo = new OpenStackRepicaAvailabilityZone.RegionInfo();
        region.setRegionId(reverseAZ ? (String)item.get("primary_region_id") : (String)item.get("second_region_id"));
        region.setRegionName(reverseAZ ? (String)item.get("primary_region_name") : (String)item.get("second_region_name"));
        regionInfo.setPrimaryRegion(region);
        region = new OpenStackRepicaAvailabilityZone.Region();
        region.setRegionId(reverseAZ ? (String)item.get("second_region_id") : (String)item.get("primary_region_id"));
        region.setRegionName(reverseAZ ? (String)item.get("second_region_name") : (String)item.get("primary_region_name"));
        regionInfo.setSecondRegion(region);
        regionInfo.setAzPairs(azPairs);
        regionPairs.add(regionInfo);
    }

    private void deleteRepeatAZMap(List<Map<String, Object>> maps) {
        for (int num = 0; num < maps.size(); ++num) {
            for (int j = maps.size() - 1; j > num; --j) {
                boolean reverseCheckEqual;
                Map<String, Object> firstItem = maps.get(num);
                Map<String, Object> secondItem = maps.get(j);
                String firstPrimaryRegionId = (String)firstItem.get("primary_region_id");
                String firstDrregionId = (String)firstItem.get("second_region_id");
                String firstPrimaryAzId = (String)firstItem.get("primary_az_id");
                String firstDrZzId = (String)firstItem.get("second_az_id");
                String firstSameRegionDrZzId = VerifyUtil.isEmpty((String)((String)firstItem.get("dr_second_az_id"))) ? "" : (String)firstItem.get("dr_second_az_id");
                String sencondPrimaryRegionId = (String)secondItem.get("primary_region_id");
                String sencondDrRegionId = (String)secondItem.get("second_region_id");
                String sencondPrimaryAzId = (String)secondItem.get("primary_az_id");
                String sencondDrAzId = (String)secondItem.get("second_az_id");
                String sencondSameRegionDrZzId = VerifyUtil.isEmpty((String)((String)secondItem.get("dr_second_az_id"))) ? "" : (String)secondItem.get("dr_second_az_id");
                boolean checkEqual = firstPrimaryRegionId.equals(sencondPrimaryRegionId) && firstDrregionId.equals(sencondDrRegionId) && firstPrimaryAzId.equals(sencondPrimaryAzId) && firstDrZzId.equals(sencondDrAzId) && firstSameRegionDrZzId.equals(sencondSameRegionDrZzId);
                boolean bl = reverseCheckEqual = firstPrimaryRegionId.equals(sencondDrRegionId) && firstDrregionId.equals(sencondPrimaryRegionId) && firstPrimaryAzId.equals(sencondDrAzId) && firstDrZzId.equals(sencondPrimaryAzId) && firstSameRegionDrZzId.equals(sencondSameRegionDrZzId);
                if (!checkEqual && !reverseCheckEqual) continue;
                maps.remove(j);
            }
        }
    }

    protected boolean sameAZInSameRegion(int azIndex, List<OpenStackRepicaAvailabilityZone.RegionInfo> regionPairs, Map<String, Object> item, ServiceInstaceEnumDefine.ServiceInstanceTypeE type) {
        OpenStackRepicaAvailabilityZone.Az azNameAndId = null;
        boolean isAddSucc = false;
        OpenStackRepicaAvailabilityZone.RegionInfo regionPair = regionPairs.get(azIndex);
        String primaryRegionId = regionPair.getPrimaryRegion().getRegionId();
        String secondRegionId = regionPair.getSecondRegion().getRegionId();
        OpenStackRepicaAvailabilityZone.Az drAzNameAndId = this.getDrAzNameAndId(item, type);
        if (primaryRegionId.equals(item.get("primary_region_id")) && secondRegionId.equals(item.get("second_region_id"))) {
            isAddSucc = true;
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            OpenStackRepicaAvailabilityZone.AzPair azPair = new OpenStackRepicaAvailabilityZone.AzPair();
            azNameAndId.setAzId((String)item.get("primary_az_id"));
            azNameAndId.setAzName((String)item.get("primary_az_name"));
            azPair.setPrimaryAz(azNameAndId);
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            azNameAndId.setAzId((String)item.get("second_az_id"));
            azNameAndId.setAzName((String)item.get("second_az_name"));
            azPair.setSecondAz(azNameAndId);
            if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.equals((Object)type)) {
                azPair.setDrRregionSsecondAz(drAzNameAndId);
            }
            List azPairs = regionPair.getAzPairs();
            azPairs.add(azPair);
            regionPairs.get(azIndex).setAzPairs(azPairs);
        } else if (primaryRegionId.equals(item.get("second_region_id")) && secondRegionId.equals(item.get("primary_region_id"))) {
            isAddSucc = true;
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            OpenStackRepicaAvailabilityZone.AzPair azPair = new OpenStackRepicaAvailabilityZone.AzPair();
            azNameAndId.setAzId((String)item.get("second_az_id"));
            azNameAndId.setAzName((String)item.get("second_az_name"));
            azPair.setPrimaryAz(azNameAndId);
            azNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            azNameAndId.setAzId((String)item.get("primary_az_id"));
            azNameAndId.setAzName((String)item.get("primary_az_name"));
            azPair.setSecondAz(azNameAndId);
            if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.equals((Object)type)) {
                azPair.setDrRregionSsecondAz(drAzNameAndId);
            }
            List azPairs = regionPair.getAzPairs();
            azPairs.add(azPair);
            regionPairs.get(azIndex).setAzPairs(azPairs);
        }
        return isAddSucc;
    }

    private OpenStackRepicaAvailabilityZone.Az getDrAzNameAndId(Map<String, Object> item, ServiceInstaceEnumDefine.ServiceInstanceTypeE type) {
        OpenStackRepicaAvailabilityZone.Az drAzNameAndId = null;
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.equals((Object)type)) {
            drAzNameAndId = new OpenStackRepicaAvailabilityZone.Az();
            drAzNameAndId.setAzId((String)item.get("dr_second_az_id"));
            drAzNameAndId.setAzName((String)item.get("dr_second_az_name"));
        }
        return drAzNameAndId;
    }

    protected JSONObject getCreateInstanceJsonObject(String projectId, BcsCreateInstanceRequest request, String reqId, JSONObject evsQuota) {
        ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
        ExtendParamInfo extendParam = new ExtendParamInfo();
        extendParam.setSubscriptionId(request.getSubscriptionId());
        extendParam.setEvsQuota(evsQuota);
        String taskId = this.getInstanceService().createServiceInstance(pg, extendParam);
        JSONObject json = new JSONObject();
        json.put((Object)"task_id", (Object)taskId);
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
        return json;
    }

    protected ProtectGroup convertInstanceBOToPg(CreateInstanceRequest request, String projectId) {
        ProtectGroup pg = new ProtectGroup();
        ServiceInstanceBO instance = request.getInstance();
        pg.setName(instance.getName());
        pg.setDescription(instance.getDescription());
        pg.setProperty("regionId", (Object)instance.getRegionName());
        pg.setProperty("projectId", (Object)projectId);
        pg.setProperty("zoneName", (Object)instance.getAzName());
        pg.setProperty("originalAvailableZone", (Object)instance.getAzName());
        if (!VerifyUtil.isEmpty((String)instance.getSlaveRegionName())) {
            pg.setProperty("drRegionId", (Object)instance.getSlaveRegionName());
        }
        if (!VerifyUtil.isEmpty((String)instance.getRemoteProjectId())) {
            pg.setProperty("drProjectId", (Object)instance.getRemoteProjectId());
        }
        if (!VerifyUtil.isEmpty((String)instance.getSlaveAzName())) {
            pg.setProperty("drZoneName", (Object)instance.getSlaveAzName());
        }
        if (null != instance.getDrAvailableZone()) {
            pg.setProperty("prod_region_drZoneName", (Object)instance.getDrAvailableZone());
        }
        pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
        pg.setPoType(12);
        PolicyTemplate template = new PolicyTemplate();
        this.setPgTemplate(pg, instance, template);
        HashSet<ProtectObject> poList = new HashSet<ProtectObject>();
        if (VerifyUtil.isEmpty((Collection)instance.getServers())) {
            logger.error((Object)"Instance servers is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (ServerBO server : instance.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            poList.add(po);
        }
        pg.setPolist(poList);
        IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().lookup("user/usermgr");
        if (null == userMgr) {
            logger.error((Object)"get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        User user = userMgr.getUserByName("admin");
        if (null == user) {
            logger.error((Object)"get admin user failed.");
            throw new LegoCheckedException(1073947393L);
        }
        pg.setOwnerId(user.getUserId());
        return pg;
    }

    protected void setPgTemplate(ProtectGroup pg, ServiceInstanceBO instance, PolicyTemplate template) {
        if (ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.SYNCHRONIZE.getValue().equals(instance.getReplicationType())) {
            template.setType(21);
        } else {
            template.setType(22);
            PolicyBO policy = instance.getPolicy();
            Schedule autoSchedule = this.convertPolicyToSchedule(template, policy);
            template.getSchedules().add(autoSchedule);
        }
        pg.setTemplate(template);
    }

    protected Schedule convertPolicyToSchedule(PolicyTemplate template, PolicyBO policy) {
        Schedule autoSchedule = this.convertPolicyToSchedule(policy);
        autoSchedule.setPolicyTemplate(template);
        return autoSchedule;
    }

    protected ProtectObject convertServerBOToPo(ServerBO server) {
        ProtectObject po = new ProtectObject();
        if (VerifyUtil.isEmpty((Object)server)) {
            logger.error((Object)"the serverBO is empty");
            throw new LegoCheckedException(1073947393L);
        }
        po.setMoUuid(server.getServerId());
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)server.getVolumes())) {
            throw new LegoCheckedException(1073947393L);
        }
        for (VolumeBO volume : server.getVolumes()) {
            JSONObject json = new JSONObject();
            if (VerifyUtil.isEmpty((String)volume.getVolumeId())) {
                throw new LegoCheckedException(1073947393L);
            }
            json.put((Object)"volumeId", (Object)volume.getVolumeId());
            if (!VerifyUtil.isEmpty((String)volume.getDrVolumeType())) {
                json.put((Object)"drVolumeType", (Object)volume.getDrVolumeType());
            }
            if (!VerifyUtil.isEmpty((String)volume.getVolumeType())) {
                json.put((Object)"volumeType", (Object)volume.getVolumeType());
            }
            array.add((Object)json);
        }
        po.setProperty("volumeConfig", (Object)array.toString());
        if (!VerifyUtil.isEmpty((String)server.getOccupiedServerId())) {
            po.setProperty("occupied_vm", (Object)server.getOccupiedServerId());
        }
        return po;
    }

    private Schedule convertPolicyToSchedule(PolicyBO policy) {
        Schedule autoSchedule = new Schedule();
        autoSchedule.setScheduleMode(0);
        autoSchedule.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        autoSchedule.setScheduleId(UUIDGenerator.getUUID());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 30);
        Date beginTime = cal.getTime();
        autoSchedule.setStartTime(String.valueOf(beginTime.getTime()));
        if (VerifyUtil.isEmpty((Object)policy)) {
            logger.error((Object)"Policy is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)policy.getPeriodInterval())) {
            logger.error((Object)"Policy period interval is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            autoSchedule.setPeriodInterval(Integer.parseInt(policy.getPeriodInterval()));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"convertPolicyToSchedule failed.");
            throw new LegoCheckedException(1073947393L, "PeriodInterval is error.", (Throwable)e);
        }
        if (VerifyUtil.isEmpty((String)policy.getPeriodType())) {
            logger.error((Object)"Policy period type is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if ("minute".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(0);
        } else if ("hour".equals(policy.getPeriodType())) {
            autoSchedule.setPeriodType(1);
        } else {
            autoSchedule.setPeriodType(2);
            if (VerifyUtil.isEmpty((String)policy.getTimePoint())) {
                logger.error((Object)"Policy period time point is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            String[] schduleTime = policy.getTimePoint().split(":");
            if (null == schduleTime || schduleTime.length != 2) {
                throw new LegoCheckedException(1073947393L, "TimePoint is error.");
            }
            autoSchedule.setHours(schduleTime[0]);
            autoSchedule.setMinutes(schduleTime[1]);
        }
        return autoSchedule;
    }

    protected Response validateCreateCsdrRequestParam(String projectId, CreateInstanceRequest request) throws RestException {
        String description;
        String subscriptionId;
        this.recordRequestLog("projectid is " + projectId + "," + (request == null ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (request instanceof BcsCreateInstanceRequest && !ParamChecker.checkGeneralId((String)(subscriptionId = ((BcsCreateInstanceRequest)request).getSubscriptionId()))) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        if (request == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "request is null.");
        }
        if (!this.validateInstanceParam(request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String serviceInstanceName = request.getInstance().getName();
        if (!this.validateNameDesc(serviceInstanceName, description = request.getInstance().getDescription())) {
            return this.wrong(Response.Status.BAD_REQUEST, "The instance's name or description parameter is error.");
        }
        String type = request.getInstance().getType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(type)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not support instance type.");
        }
        String replicationType = request.getInstance().getReplicationType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.SYNCHRONIZE.getValue().equals(replicationType) && !ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        PolicyBO policy = request.getInstance().getPolicy();
        if (ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType) && !this.validatePolicy(policy)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not set policy.");
        }
        return this.getResponse(Response.Status.OK, "OK");
    }

    protected boolean validateInstanceParam(CreateInstanceRequest request) {
        ServiceInstanceBO serviceInstance = request.getInstance();
        if (serviceInstance == null) {
            return false;
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(serviceInstance.getName());
        attributes.add(serviceInstance.getAzName());
        attributes.add(serviceInstance.getRegionName());
        attributes.add(serviceInstance.getSlaveAzName());
        attributes.add(serviceInstance.getSlaveRegionName());
        attributes.add(serviceInstance.getRemoteProjectId());
        attributes.add(serviceInstance.getType());
        attributes.add(serviceInstance.getReplicationType());
        try {
            CommUtils.verifyParameterList(attributes);
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRegionName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getSlaveAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getSlaveRegionName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRemoteProjectId())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getDrAvailableZone())) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (LegoCheckedException e) {
            String parameter = "name=" + serviceInstance.getName() + ",azName=" + serviceInstance.getAzName() + ",regionName=" + serviceInstance.getRegionName() + ",remoteProjectId=" + serviceInstance.getRemoteProjectId() + ",slaveName=" + serviceInstance.getSlaveAzName() + ",type=" + serviceInstance.getType() + ",type=" + serviceInstance.getReplicationType();
            logger.error((Object)("validateParam error. instance details:" + parameter), (Throwable)e);
            return false;
        }
        if (ServiceInstaceEnumDefine.ObjectType.SFS.getValue().equalsIgnoreCase(serviceInstance.getObjectType())) {
            return true;
        }
        List servers = serviceInstance.getServers();
        return this.validateServerParam(servers);
    }

    protected boolean validateServerParam(List<ServerBO> servers) {
        try {
            CommUtils.isNullCollection(servers);
            if (servers.size() > 256) {
                logger.error((Object)"validateServerParam failed. Servers in request is more than 256");
                return false;
            }
            for (ServerBO server : servers) {
                if (CommUtils.isNullStr((String)server.getServerId())) {
                    logger.error((Object)"validateServerParam failed. serverId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getServerId())) {
                    logger.error((Object)"validateServerParam failed. serverId is incorrect");
                    return false;
                }
                if (CommUtils.isNullStr((String)server.getOccupiedServerId())) {
                    logger.error((Object)"validateServerParam failed. occupied ServerId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getOccupiedServerId())) {
                    logger.error((Object)"validateServerParam failed. occupied ServerId is incorrect");
                    return false;
                }
                List volumes = server.getVolumes();
                CommUtils.isNullCollection((Collection)volumes);
                if (volumes.size() > 60) {
                    logger.error((Object)"volumes of server is more than 60");
                    return false;
                }
                if (!this.checkVolume(volumes)) continue;
                return false;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"validateServerParam error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean checkVolume(List<VolumeBO> volumes) {
        for (VolumeBO volume : volumes) {
            if (this.validateVolumeParam(volume)) continue;
            String parameter = "volumeId=" + volume.getVolumeId() + ",volumeType=" + volume.getVolumeType() + ",drVolumeType=" + volume.getDrVolumeType();
            logger.error((Object)("validateServerParam failed. volume details=" + parameter));
            return true;
        }
        return false;
    }

    protected boolean validatePolicy(PolicyBO policy) {
        if (null == policy) {
            logger.error((Object)"policy is null.");
            return false;
        }
        try {
            policy.validate();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"policy is invalid.", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean validateNameDesc(String name, String description) {
        if (!CommUtil.checkDrmDescParam((String)description)) {
            logger.error((Object)("validateNameDesc failed. description=" + description));
            return false;
        }
        if (!CommUtil.checkDrmNameParam((String)name)) {
            logger.error((Object)("validateNameDesc failed. name=" + name));
            return false;
        }
        return true;
    }

    protected JSONObject getEvsQuotaFromResponseForReportOrder(ThrowableSupplier<Response, RestException> checkQuotaResponseSupplier) {
        JSONObject result = new JSONObject();
        if (VerifyUtil.isEmpty(checkQuotaResponseSupplier)) {
            return result;
        }
        Response checkQuotaResponse = null;
        try {
            checkQuotaResponse = checkQuotaResponseSupplier.get();
        }
        catch (RestException | LegoCheckedException e) {
            logger.error((Object)"Get check quota response failed, error message:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (VerifyUtil.isEmpty((Object)checkQuotaResponse) || Response.Status.OK.getStatusCode() != checkQuotaResponse.getStatus()) {
            return result;
        }
        JSONObject entityObject = null;
        try {
            entityObject = JSONObject.fromObject((Object)checkQuotaResponse.getEntity());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"The quota in response is empty, error message:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (VerifyUtil.isEmpty((Map)entityObject)) {
            return result;
        }
        JSONArray quotas = entityObject.getJSONArray("quotas");
        if (VerifyUtil.isEmpty((Collection)quotas)) {
            return result;
        }
        IQuotaService service = (IQuotaService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IQuotaService.class.getName(), IQuotaService.class);
        String evsId = service.getEVSServiceId();
        Iterator iterator = quotas.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof JSONObject)) {
                iterator.remove();
                continue;
            }
            JSONObject quota = (JSONObject)object;
            JSONArray usages = quota.getJSONArray("usages");
            this.quotaUsageFilter(evsId, usages);
            if (!VerifyUtil.isEmpty((Collection)usages)) continue;
            iterator.remove();
        }
        if (VerifyUtil.isEmpty((Collection)quotas)) {
            return result;
        }
        result.set((Object)"quotas", (Object)quotas);
        return result;
    }

    private void quotaUsageFilter(String evsId, JSONArray usages) {
        if (VerifyUtil.isEmpty((Collection)usages)) {
            logger.debug((Object)"The usages is empty.");
            return;
        }
        Iterator usageIterator = usages.iterator();
        while (usageIterator.hasNext()) {
            Object usageObj = usageIterator.next();
            if (!(usageObj instanceof JSONObject)) {
                usageIterator.remove();
                continue;
            }
            JSONObject usage = (JSONObject)usageObj;
            if (!evsId.equals(usage.getString("service_id"))) {
                usageIterator.remove();
                continue;
            }
            JSONArray resources = usage.getJSONArray("resources");
            this.quotaResourceFilter(resources);
            if (!VerifyUtil.isEmpty((Collection)resources)) continue;
            usageIterator.remove();
        }
    }

    private void quotaResourceFilter(JSONArray resources) {
        if (VerifyUtil.isEmpty((Collection)resources)) {
            logger.debug((Object)"The resources is empty.");
            return;
        }
        Iterator resourceIterator = resources.iterator();
        while (resourceIterator.hasNext()) {
            Object resourceObj = resourceIterator.next();
            if (!(resourceObj instanceof JSONObject)) {
                resourceIterator.remove();
                continue;
            }
            JSONObject resource = (JSONObject)resourceObj;
            if (resource.getInt("used") < 0) continue;
            resourceIterator.remove();
        }
    }
}

