/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features;

import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.CsdrFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public class CshaCsdrFeatureRestService
extends CsdrFeatureRestService {
    private static final Log logger = LogFactory.getInstance(CshaCsdrFeatureRestService.class);

    @Override
    public Response queryAzPairs(String regionId) {
        return super.queryAzPairs(regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION);
    }

    @Override
    public Response createServiceInstanceQuotasBudget(String projectId, CreateInstanceRequest request) throws RestException {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(request == null ? "" : request.getInstance().getName()));
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        Response response = this.validateCreateCsdrRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        ServiceInstanceBO instance = request.getInstance();
        String replicationType = instance.getReplicationType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support replication type.type=" + replicationType);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        String type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instance.getType());
        try {
            ProtectGroup pg = super.convertInstanceBOToPg(request, projectId);
            JSONObject returnJson = this.getJsonObject(projectId, type, pg);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed");
            throw new LegoCheckedException(-1L);
        }
    }

    private JSONObject getJsonObject(String projectId, String type, ProtectGroup pg) {
        pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue());
        pg.getTemplate().setType(37);
        pg.setProperty("originalAvailableRegion", pg.getProps().get("regionId"));
        ExtendParamInfo extendParam = new ExtendParamInfo();
        extendParam.setCheck(true);
        List list = this.getInstanceService().checkCreateInstanceParamAndCalQuota(pg, projectId, extendParam);
        JSONObject returnJson = new JSONObject();
        String regionId = (String)pg.getProps().get("regionId");
        String protId = (String)pg.getProps().get("projectId");
        String drRegionId = (String)pg.getProps().get("drRegionId");
        String drProId = (String)pg.getProps().get("drProjectId");
        JSONArray array = this.constructQuotaResult(type, protId, regionId, drProId, drRegionId, list);
        String drAzid = (String)pg.getProps().get("drZoneName");
        String regionDrAzid = (String)pg.getProps().get("prod_region_drZoneName");
        ArrayList<QuotaResourcesBo> csdrQuota = new ArrayList<QuotaResourcesBo>();
        ArrayList<QuotaResourcesBo> cshaQuota = new ArrayList<QuotaResourcesBo>();
        this.getCsdrQuotaList(csdrQuota, list);
        this.getCshaQuotaList(cshaQuota, list);
        array.add((Object)this.constructEvsQuota(drAzid, drProId, this.getIdFromUuid(drRegionId), csdrQuota));
        array.add((Object)this.constructEvsQuota(regionDrAzid, protId, this.getIdFromUuid(regionId), cshaQuota));
        returnJson.put((Object)"quotas", (Object)array);
        logger.debug((Object)"createServiceInstanceQuotasBudget: %s, projectId= %s", new Object[]{array, projectId});
        return returnJson;
    }

    private void getCshaQuotaList(List<QuotaResourcesBo> cshaQuota, List<QuotaResourcesBo> list) {
        ArrayList<String> cshaQuotaTypes = new ArrayList<String>();
        cshaQuotaTypes.add("csha.vol.size");
        cshaQuotaTypes.add("csha.vol.num");
        cshaQuotaTypes.add("csha.instance.num");
        cshaQuotaTypes.add("csha_volumes");
        cshaQuotaTypes.add("csha_gigabytes");
        for (QuotaResourcesBo quotaResourcesBo : list) {
            if (!cshaQuotaTypes.contains(quotaResourcesBo.getType())) continue;
            cshaQuota.add(quotaResourcesBo);
        }
    }

    private void getCsdrQuotaList(List<QuotaResourcesBo> csdrQuota, List<QuotaResourcesBo> list) {
        ArrayList<String> csdrQuotaTypes = new ArrayList<String>();
        csdrQuotaTypes.add("csdr.vol.size");
        csdrQuotaTypes.add("csdr.vol.num");
        csdrQuotaTypes.add("csdr.instance.num");
        csdrQuotaTypes.add("volumes");
        csdrQuotaTypes.add("gigabytes");
        for (QuotaResourcesBo quotaResourcesBo : list) {
            if (!csdrQuotaTypes.contains(quotaResourcesBo.getType())) continue;
            csdrQuota.add(quotaResourcesBo);
        }
    }

    @Override
    protected JSONArray constructQuotaResult(String type, String projectId, String regionId, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(type)) {
            logger.error((Object)("type is not support , constructQuotaResult failed , type:" + type));
            throw new LegoCheckedException(1073947393L);
        }
        JSONArray csdrQuotaResourceList = new JSONArray();
        JSONArray vhaQuotaResourceList = new JSONArray();
        for (QuotaResourcesBo bo : list) {
            if ("gigabytes".equals(bo.getType()) || "volumes".equals(bo.getType())) continue;
            this.getCsdrQuotaResourceList(csdrQuotaResourceList, bo);
            this.getVhaQuotaResourceList(vhaQuotaResourceList, bo);
        }
        JSONArray usagesList = new JSONArray();
        JSONObject csdrUsage = new JSONObject();
        if (!VerifyUtil.isEmpty((Collection)csdrQuotaResourceList)) {
            csdrUsage.put((Object)"resources", (Object)csdrQuotaResourceList);
            csdrUsage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getFrontValue());
            usagesList.add((Object)csdrUsage);
        }
        if (!VerifyUtil.isEmpty((Collection)vhaQuotaResourceList)) {
            JSONObject vhaUsage = new JSONObject();
            vhaUsage.put((Object)"resources", (Object)vhaQuotaResourceList);
            vhaUsage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getFrontValue());
            usagesList.add((Object)vhaUsage);
        }
        JSONArray quotas = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)usagesList)) {
            JSONObject quota = new JSONObject();
            quota.put((Object)"project_id", (Object)projectId);
            quota.put((Object)"region_id", (Object)regionId);
            quota.put((Object)"usages", (Object)usagesList);
            quotas.add((Object)quota);
        }
        if (null != drProjectId && !VerifyUtil.isEmpty((Map)csdrUsage)) {
            JSONObject drQuota = new JSONObject();
            drQuota.put((Object)"project_id", (Object)drProjectId);
            drQuota.put((Object)"region_id", (Object)drRegionId);
            JSONArray drUsagesList = new JSONArray();
            drUsagesList.add((Object)csdrUsage);
            drQuota.put((Object)"usages", (Object)drUsagesList);
            quotas.add((Object)drQuota);
        }
        return quotas;
    }

    private void getVhaQuotaResourceList(JSONArray vhaQuotaResourceList, QuotaResourcesBo bo) {
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(this.getInstanceType().getValue())) {
            return;
        }
        ArrayList<String> vhaMeterTypes = new ArrayList<String>();
        vhaMeterTypes.add("csha.vol.size");
        vhaMeterTypes.add("csha.vol.num");
        vhaMeterTypes.add("csha.instance.num");
        this.addQuotaResource(vhaQuotaResourceList, bo, vhaMeterTypes);
    }

    private void getCsdrQuotaResourceList(JSONArray csdrQuotaResourceList, QuotaResourcesBo bo) {
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue().equals(this.getInstanceType().getValue())) {
            return;
        }
        ArrayList<String> csdrMeterTypes = new ArrayList<String>();
        csdrMeterTypes.add("csdr.instance.num");
        csdrMeterTypes.add("csdr.vol.num");
        csdrMeterTypes.add("csdr.vol.size");
        this.addQuotaResource(csdrQuotaResourceList, bo, csdrMeterTypes);
    }

    private void addQuotaResource(JSONArray quotaResourceList, QuotaResourcesBo bo, List<String> csdrMeterTypes) {
        if (csdrMeterTypes.contains(bo.getType())) {
            JSONObject quotaResource = new JSONObject();
            quotaResource.put((Object)"resource", (Object)bo.getType());
            quotaResource.put((Object)"used", (Object)Float.valueOf(bo.getQuota()));
            quotaResourceList.add((Object)quotaResource);
        }
    }

    @Override
    protected Response validateCreateCsdrRequestParam(String projectId, CreateInstanceRequest request) throws RestException {
        Response response = super.validateCreateCsdrRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        ServiceInstanceBO serviceInstance = request.getInstance();
        if (null == serviceInstance.getDrAvailableZone()) {
            logger.error((Object)"validateServerParam failed. dr AvailableZone is null");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        if (VerifyUtil.isEmpty((Collection)serviceInstance.getServers())) {
            logger.error((Object)"Instance servers is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (ServerBO server : serviceInstance.getServers()) {
            if (!CommUtils.isNullStr((String)server.getCshaOccupiedServerId())) continue;
            logger.error((Object)"validateServerParam failed. csha dr serverId is null");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        return this.getResponse(Response.Status.OK, "OK");
    }

    @Override
    public Response createServiceInstance(String projectId, BcsCreateInstanceRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        Response response = this.validateCreateCsdrRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        String replicationType = request.getInstance().getReplicationType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support replication type.type=" + replicationType);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        String serviceInstanceName = request.getInstance().getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serviceInstanceName);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)request.getInstance().getType());
        try {
            ProtectGroup pg = super.convertInstanceBOToPg(request, projectId);
            pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue());
            pg.getTemplate().setType(37);
            pg.setProperty("originalAvailableRegion", pg.getProps().get("regionId"));
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            extendParam.setEvsQuota(this.getEvsQuotaFromResponseForReportOrder(() -> this.createServiceInstanceQuotasBudget(projectId, request)));
            String taskId = this.getInstanceService().createServiceInstance(pg, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstance failed");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstance failed");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public Response addServerQuotasBudget(String projectId, String instanceId, AddServersRequest request) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        try {
            VerifyUtil.checkObjs((Object[])new Object[]{projectId, instanceId, request});
        }
        catch (Exception e) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "parameters is empty.");
            logger.error((Object)"parameters is empty:projectId=%s,instanceId=%s", new Object[]{projectId, instanceId});
            return this.getResponse(Response.Status.BAD_REQUEST, "parameters is empty.");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers is empty.");
        }
        if (!this.validateServerParam(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers param is not correct.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers param is not correct.");
        }
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addServerQuotasBudget failed");
            throw e;
        }
        try {
            JSONObject returnJson = this.getJsonObject(projectId, instanceId, addPos, instanceInfoBO);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addServerQuotasBudget failed");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addServerQuotasBudget failed");
            throw new LegoCheckedException(-1L);
        }
    }

    private JSONObject getJsonObject(String projectId, String instanceId, Set<ProtectObject> addPos, InstanceInfoBO instanceInfoBO) {
        ExtendParamInfo extendParam = new ExtendParamInfo();
        extendParam.setCheck(true);
        List list = this.getInstanceService().addServerToServiceInstanceAndCalQuota(projectId, instanceId, addPos, extendParam);
        JSONObject returnJson = new JSONObject();
        JSONArray array = this.constructAddVolumeToVmQuotasBudget(instanceInfoBO, list);
        returnJson.put((Object)"quotas", (Object)array);
        logger.debug((Object)"addServerQuotasBudget: %s", new Object[]{array});
        return returnJson;
    }

    @Override
    protected JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO instanceInfoBO, List<QuotaResourcesBo> list) {
        String protId = instanceInfoBO.getProjectId();
        String regionId = instanceInfoBO.getRegion();
        String drProId = instanceInfoBO.getRemoteProjectId();
        String drRegionId = instanceInfoBO.getSlaveRegionName();
        String type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.getValue();
        JSONArray array = this.constructQuotaResult(type, protId, regionId, drProId, this.getIdFromUuid(drRegionId), list);
        String drAzid = instanceInfoBO.getSalveAvailableZone();
        String regionDrAzid = instanceInfoBO.getCshaRemoteAvailableZone();
        ArrayList<QuotaResourcesBo> csdrQuota = new ArrayList<QuotaResourcesBo>();
        ArrayList<QuotaResourcesBo> cshaQuota = new ArrayList<QuotaResourcesBo>();
        this.getCsdrQuotaList(csdrQuota, list);
        this.getCshaQuotaList(cshaQuota, list);
        array.add((Object)this.constructEvsQuota(drAzid, drProId, this.getIdFromUuid(drRegionId), csdrQuota));
        array.add((Object)this.constructEvsQuota(regionDrAzid, protId, this.getIdFromUuid(regionId), cshaQuota));
        return array;
    }

    @Override
    public Response addServer(String projectId, String instanceId, BcsAddServersRequest request) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        try {
            VerifyUtil.checkObjs((Object[])new Object[]{projectId, instanceId, request});
        }
        catch (Exception e) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "parameters is empty.");
            logger.error((Object)"parameters is empty:projectId=%s,instanceId=%s", new Object[]{projectId, instanceId});
            return this.getResponse(Response.Status.BAD_REQUEST, "parameters is empty");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers is empty.");
        }
        if (!this.validateServerParam(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers param is not correct.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers param is not correct.");
        }
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            extendParam.setEvsQuota(this.getEvsQuotaFromResponseForReportOrder(() -> this.addServerQuotasBudget(projectId, instanceId, request)));
            String taskId = this.getInstanceService().addServerToServiceInstance(projectId, instanceId, addPos, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordSuccLog(reqId, instanceInfoBO, taskId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addServer failed");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addServer failed");
            throw new LegoCheckedException(-1L);
        }
    }

    private void recordSuccLog(String reqId, InstanceInfoBO instanceInfoBO, String taskId) {
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
    }

    @Override
    protected boolean validateServerParam(List<ServerBO> servers) {
        try {
            CommUtils.isNullCollection(servers);
            for (ServerBO server : servers) {
                if (CommUtils.isNullStr((String)server.getServerId())) {
                    logger.error((Object)"validateServerParam failed. serverId is null");
                    return false;
                }
                if (CommUtils.isNullStr((String)server.getOccupiedServerId())) {
                    logger.error((Object)"validateServerParam failed. occupied ServerId is null");
                    return false;
                }
                if (CommUtils.isNullStr((String)server.getCshaOccupiedServerId())) {
                    logger.error((Object)"validateServerParam failed. csha dr serverId is null");
                    return false;
                }
                List volumes = server.getVolumes();
                CommUtils.isNullCollection((Collection)volumes);
                for (VolumeBO volume : volumes) {
                    if (this.validateVolumeParam(volume)) continue;
                    String parameter = "volumeId=" + volume.getVolumeId() + ",volumeType=" + volume.getVolumeType() + ",drVolumeType=" + volume.getVolumeType();
                    logger.error((Object)("validateServerParam failed. volume details=" + parameter));
                    return false;
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"validateServerParam error.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected ProtectObject convertServerBOToPo(ServerBO server) {
        ProtectObject po = super.convertServerBOToPo(server);
        po.setProperty("csha_occupied_vm", (Object)server.getCshaOccupiedServerId());
        return po;
    }

    @Override
    public ServiceInstaceEnumDefine.ServiceInstanceTypeE getInstanceType() {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION;
    }
}

