/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BatchSubscriptionRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsVerifyServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.Subscription;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.lego.cbb.cloudservice.sdk.model.MultiCloudProjectIdMapping;
import com.huawei.lego.cbb.cloudservice.sdk.util.MultiCloudUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public class MultiCloudAdapterAspect {
    private static final Log LOGGER = LogFactory.getInstance(MultiCloudAdapterAspect.class);
    private static final String HEADER_KEY_CERTER_PROJECTID = "center-cloud-projectid";
    private static final String HEADER_KEY_REGION_PROJECTID = "region-cloud-projectid";
    private static final String HEADER_KEY_CERTER_DRPROJECTID = "center-cloud-drprojectid";
    private static final String HEADER_KEY_REGION_DRPROJECTID = "region-cloud-drprojectid";
    private static final String HEADER_KEY_REGION_ID = "region";
    private static final List<String> PROJECTID_NAME = Arrays.asList("project_id", "remote_project_id");

    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature signature;
        String regionId;
        String regionCloudProjectid;
        Object[] args = joinPoint.getArgs();
        if (!MultiCloudUtil.isSupportMultiCloud()) {
            LOGGER.debug((Object)"The %s is close, nothing need to do.", new Object[]{"multi.cloud.adapter.switch"});
            return joinPoint.proceed(args);
        }
        Object target = joinPoint.getTarget();
        if (VerifyUtil.isEmpty((Object)target) || !(target instanceof AbstractRestService)) {
            LOGGER.debug((Object)"The target is not a AbstractRestService.");
            return joinPoint.proceed(args);
        }
        AbstractRestService restService = (AbstractRestService)target;
        HttpServletRequest request = restService.getRequest();
        String centerCloudProjectid = request.getHeader(HEADER_KEY_CERTER_PROJECTID);
        if (this.checkMappingVaild(centerCloudProjectid, regionCloudProjectid = request.getHeader(HEADER_KEY_REGION_PROJECTID), regionId = request.getHeader(HEADER_KEY_REGION_ID))) {
            MultiCloudUtil.refreshCacheAndGet((String)centerCloudProjectid, (String)regionCloudProjectid, (String)regionId);
        }
        if (VerifyUtil.isEmpty((Object)(signature = joinPoint.getSignature())) || !(signature instanceof MethodSignature)) {
            LOGGER.debug((Object)"The signature is not a MethodSignature.");
            return joinPoint.proceed(args);
        }
        MethodSignature methodSignature = (MethodSignature)signature;
        Annotation[][] annotations = Optional.of(methodSignature).map(MethodSignature::getMethod).map(Method::getParameterAnnotations).orElse(new Annotation[0][]);
        for (int i = 0; i < annotations.length; ++i) {
            if (VerifyUtil.isEmpty((Object)args[i])) continue;
            Annotation[] annotation = annotations[i];
            this.resetProjectIdParam(args, regionId, i, annotation);
            this.resetBatchBcsVerifyServersRequest(args[i], request);
            this.resetBatchSubscriptionRequest(args[i]);
        }
        return joinPoint.proceed(args);
    }

    private void resetBatchSubscriptionRequest(Object argument) {
        if (!(argument instanceof BatchSubscriptionRequest)) {
            LOGGER.debug((Object)"The argument is not a BatchSubscriptionRequest.");
            return;
        }
        BatchSubscriptionRequest batchSubscriptionRequest = (BatchSubscriptionRequest)argument;
        List<Subscription> subscriptions = batchSubscriptionRequest.getSubscriptions();
        if (VerifyUtil.isEmpty(subscriptions)) {
            LOGGER.debug((Object)"The subscriptions of BatchSubscriptionRequest is empty.");
            return;
        }
        for (Subscription subscription : subscriptions) {
            String params = subscription.getParams();
            if (VerifyUtil.isEmpty((String)params)) continue;
            JSONObject data = JSONObject.fromObject((Object)params);
            JSONObject instanceObj = data.getJSONObject("instance");
            String regionId = data.getString("region_for_multi_cloud", "");
            if (!VerifyUtil.isEmpty((Map)instanceObj)) {
                LOGGER.debug((Object)"The instance is not empty.");
                String remoteProjectId = instanceObj.getString("remote_project_id", "");
                String remoteRegion = instanceObj.getString("remote_region", "");
                String region = instanceObj.getString(HEADER_KEY_REGION_ID, "");
                subscription.setProjectId(MultiCloudUtil.convertToTargetRegion((String)subscription.getProjectId(), (String)region));
                subscription.setParams(params.replaceAll(remoteProjectId, MultiCloudUtil.convertToTargetRegion((String)remoteProjectId, (String)remoteRegion)));
                return;
            }
            if (VerifyUtil.isEmpty((String)regionId)) {
                LOGGER.debug((Object)"The region_for_multi_cloud is empty.");
                return;
            }
            subscription.setProjectId(MultiCloudUtil.convertToTargetRegion((String)subscription.getProjectId(), (String)regionId));
        }
    }

    private void resetBatchBcsVerifyServersRequest(Object argument, HttpServletRequest request) {
        BcsVerifyServersRequest bcsVerifyServersRequest;
        String regionCloudDrProjectid;
        if (!(argument instanceof BcsVerifyServersRequest)) {
            LOGGER.debug((Object)"The argument is not a BcsVerifyServersRequest.");
            return;
        }
        String centerCloudDrProjectid = request.getHeader(HEADER_KEY_CERTER_DRPROJECTID);
        if (this.checkMappingVaild(centerCloudDrProjectid, regionCloudDrProjectid = request.getHeader(HEADER_KEY_REGION_DRPROJECTID), (bcsVerifyServersRequest = (BcsVerifyServersRequest)argument).getRemoteRegionName())) {
            MultiCloudUtil.refreshCacheAndGet((String)centerCloudDrProjectid, (String)regionCloudDrProjectid, (String)bcsVerifyServersRequest.getRemoteRegionName());
        }
        bcsVerifyServersRequest.setRemoteProjectId(MultiCloudUtil.convertToTargetRegion((String)bcsVerifyServersRequest.getRemoteProjectId(), (String)bcsVerifyServersRequest.getRemoteRegionName()));
    }

    private void resetProjectIdParam(Object[] args, String regionId, int i, Annotation[] annotation) {
        boolean isProjectIdParam = Arrays.stream(annotation).anyMatch(object -> object instanceof PathParam && PROJECTID_NAME.contains(((PathParam)object).value()) || object instanceof QueryParam && PROJECTID_NAME.contains(((QueryParam)object).value()));
        Object argument = args[i];
        if (isProjectIdParam && argument instanceof String) {
            args[i] = MultiCloudUtil.convertToTargetRegion((String)((String)argument), (String)regionId);
        }
    }

    private boolean checkMappingVaild(String centerCloudProjectId, String regionCloudProjectId, String regionId) {
        IOpenstackResourceService service = (IOpenstackResourceService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IOpenstackResourceService.class.getName(), IOpenstackResourceService.class);
        MultiCloudProjectIdMapping mapping = new MultiCloudProjectIdMapping();
        mapping.setCenterCloudProjectId(centerCloudProjectId);
        mapping.setRegionCloudProjectId(regionCloudProjectId);
        mapping.setRegionId(regionId);
        if (!service.checkMappingVaild(mapping)) {
            LOGGER.error((Object)"Input project id is invalid!");
            return false;
        }
        return true;
    }
}

