/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReflectUtil {
    private static final Log logger = LogFactory.getInstance(ReflectUtil.class);

    public static Method getMethod(Class<?> owner, String name, Class<?>[] types) {
        if (owner == null) {
            return null;
        }
        try {
            return owner.getDeclaredMethod(name, types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.debug((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            Class<?> base = owner.getSuperclass();
            if (Object.class.equals(base)) {
                return null;
            }
            return ReflectUtil.getMethod(base, name, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(Object object, String name, Class<?>[] types, Object[] args) {
        Method method = ReflectUtil.getMethod(object.getClass(), name, types);
        if (method == null) {
            return null;
        }
        boolean accessible = method.isAccessible();
        try {
            if (!accessible) {
                ReflectUtil.setAccessible(method, true);
            }
            Object object2 = method.invoke(object, args);
            return object2;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.debug((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            if (!accessible) {
                ReflectUtil.setAccessible(method, accessible);
            }
        }
        return null;
    }

    public static void setAccessible(AccessibleObject ao, boolean accessible) {
        try {
            ao.setAccessible(accessible);
        }
        catch (SecurityException e) {
            logger.error((Object)"fail to modify accessible", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            logger.debug((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            return ReflectUtil.getField(clazz.getSuperclass(), name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(Object object, String name) {
        Class<?> clazz = object.getClass();
        Field field = ReflectUtil.getField(clazz, name);
        if (field == null) {
            return null;
        }
        boolean accessible = field.isAccessible();
        try {
            if (!accessible) {
                ReflectUtil.setAccessible(field, true);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            logger.debug((Object)ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            if (!accessible) {
                ReflectUtil.setAccessible(field, accessible);
            }
        }
        return null;
    }

    public static List<Object> getValues(Object object, String path) {
        ArrayList<Object> items = new ArrayList<Object>();
        boolean added = false;
        while (!VerifyUtil.isEmpty((String)path)) {
            String field;
            int index = path.indexOf(46);
            if (index != -1) {
                field = path.substring(0, index);
                path = path.substring(index + 1);
            } else {
                field = path;
                path = null;
            }
            if (object == null) {
                return items;
            }
            if (!((object = ReflectUtil.getValue(object, field)) instanceof Collection)) continue;
            items.addAll(ReflectUtil.getValues((Collection)object, path));
            added = true;
            break;
        }
        if (!added) {
            items.add(object);
        }
        return items;
    }

    private static List<Object> getValues(Collection<?> objects, String path) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object object : objects) {
            items.addAll(ReflectUtil.getValues(object, path));
        }
        return items;
    }
}

