/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.sdk.model;

import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.PropertyAccessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class RecoveryPlan
extends DRMObject
implements PropertyAccessor {
    public static final Integer RECOVERY_PLAN = 0;
    public static final Integer MOUNT_PLAN = 1;
    private static final long serialVersionUID = -554889093211267196L;
    private static final Log logger = LogFactory.getInstance(RecoveryPlan.class);
    private String planId;
    private int planType;
    private int planStatus;
    private int planProgress;
    private Map<String, String> globalSettings;
    private Set<ProtectGroup> protectGroups;
    private Set<RecoveryLog> recoveryLogs;
    private Set<RecoveryProcessDefinition> recoveryProcesses;
    private String processesSerialMsg;
    private Set<RecoverySetting> recoverySettings;
    private int lastExecuteType;
    private int processStatus;
    private int lastTestStatus = Integer.MIN_VALUE;
    private String lastProcessorName;
    private Boolean isSynchronized = true;
    private Integer use;
    private Long createTime;
    private String recoveryTargetType;
    private Integer replicaType;
    private boolean supportConfirmReprotection = true;
    private String objectType = ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue();

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public boolean isSupportConfirmReprotection() {
        return this.supportConfirmReprotection;
    }

    public void setSupportConfirmReprotection(boolean supportConfirmReprotection) {
        this.supportConfirmReprotection = supportConfirmReprotection;
    }

    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
        this.setUuid(planId);
    }

    public int getPlanStatus() {
        return this.planStatus;
    }

    public void setPlanStatus(int planStatus) {
        this.planStatus = planStatus;
    }

    public int getPlanProgress() {
        return this.planProgress;
    }

    public void setPlanProgress(int planProgress) {
        this.planProgress = planProgress;
    }

    public void setRecoveryLogs(Set<RecoveryLog> recoveryLogs) {
        this.recoveryLogs = recoveryLogs;
    }

    public Set<RecoveryLog> getRecoveryLogs() {
        return this.recoveryLogs;
    }

    public void setRecoveryProcesses(Set<RecoveryProcessDefinition> recoveryProcesses) {
        this.recoveryProcesses = recoveryProcesses;
    }

    public Set<RecoveryProcessDefinition> getRecoveryProcesses() {
        return this.recoveryProcesses;
    }

    public void setRecoverySettings(Set<RecoverySetting> recoverySettings) {
        this.recoverySettings = recoverySettings;
    }

    public Set<RecoverySetting> getRecoverySettings() {
        return this.recoverySettings;
    }

    public void setProtectGroups(Set<ProtectGroup> protectGroups) {
        this.protectGroups = protectGroups;
    }

    public Set<ProtectGroup> getProtectGroups() {
        return this.protectGroups;
    }

    public void setLastProcessorName(String lastProcessorName) {
        this.lastProcessorName = lastProcessorName;
    }

    public String getLastProcessorName() {
        return this.lastProcessorName;
    }

    public void setGlobalSettings(Map<String, String> globalSettings) {
        this.globalSettings = globalSettings;
    }

    public Map<String, String> getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = new HashMap<String, String>();
        }
        return this.globalSettings;
    }

    public void setPlanType(int planType) {
        this.planType = planType;
    }

    public int getPlanType() {
        return this.planType;
    }

    public void setLastExecuteType(int lastExecuteType) {
        this.lastExecuteType = lastExecuteType;
    }

    public int getLastExecuteType() {
        return this.lastExecuteType;
    }

    public void setLastTestStatus(int lastTestStatus) {
        this.lastTestStatus = lastTestStatus;
    }

    public int getLastTestStatus() {
        return this.lastTestStatus;
    }

    public int getProcessStatus() {
        return this.processStatus;
    }

    public void setProcessStatus(int processStatus) {
        this.processStatus = processStatus;
    }

    public RecoveryProcessDefinition getRecoveryProcess(DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        RecoveryProcessDefinition rpDefinition = null;
        for (RecoveryProcessDefinition rpd : this.recoveryProcesses) {
            if (type.getValue() != rpd.getProcType()) continue;
            rpDefinition = rpd;
            break;
        }
        return rpDefinition;
    }

    public void setProcessesSerialMsg(String processesSerialMsg) {
        this.processesSerialMsg = processesSerialMsg;
    }

    public String getProcessesSerialMsg() {
        return this.processesSerialMsg;
    }

    public void setIsSynchronized(Boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public Boolean getIsSynchronized() {
        return this.isSynchronized;
    }

    public Integer getUse() {
        return this.use;
    }

    public void setUse(Integer use) {
        this.use = use;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getRecoveryTargetType() {
        return this.recoveryTargetType;
    }

    public void setRecoveryTargetType(String recoveryTargetType) {
        this.recoveryTargetType = recoveryTargetType;
    }

    public Integer getReplicaType() {
        return this.replicaType;
    }

    public void setReplicaType(Integer replicaType) {
        this.replicaType = replicaType;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public ProtectGroup getProtectGroup() {
        if (this.protectGroups == null) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.protectGroups.stream().findFirst().orElse(null);
        if (protectGroup == null) {
            throw new LegoCheckedException(1073947393L);
        }
        return protectGroup;
    }

    public String getPoRecoverySetting(ProtectObject po, String key) {
        return this.getPoRecoverySetting(po, key, String.class::cast);
    }

    public String getPoRecoverySetting(ProtectObject po, String key, String def) {
        return this.getPoRecoverySetting(po, key, def, String.class::cast);
    }

    public <T> T getPoRecoverySetting(ProtectObject po, String key, Function<String, T> converter) {
        return this.getPoRecoverySetting(po, key, null, converter);
    }

    public <T> T getPoRecoverySetting(ProtectObject po, String key, T def, Function<String, T> converter) {
        Set settings = Optional.ofNullable(this.getRecoverySettings()).orElse(Collections.emptySet());
        for (RecoverySetting setting : settings) {
            if (!setting.getOwnerId().equals(po.getUuid()) || !setting.getName().equals(key)) continue;
            try {
                return converter.apply(setting.getValue());
            }
            catch (RuntimeException e) {
                logger.error((Object)String.format(Locale.ENGLISH, "convert recovery setting '%s' of ProtectObject(id:%s) failed", key, po.getUuid()));
                throw e;
            }
        }
        return def;
    }

    public RecoveryPlan updatePoRecoverySetting(ProtectObject po, String key, String value) {
        return this.updatePoRecoverySetting(po.getUuid(), key, value);
    }

    public RecoveryPlan updatePoRecoverySetting(String poUuid, String key, String value) {
        Set<RecoverySetting> recoverySettingSet = this.getRecoverySettings();
        Boolean isExits = Boolean.FALSE;
        for (RecoverySetting rs : recoverySettingSet) {
            if (!poUuid.equals(rs.getOwnerId()) || !key.equals(rs.getName())) continue;
            isExits = Boolean.TRUE;
            rs.setValue(value);
            break;
        }
        if (!isExits.booleanValue()) {
            RecoverySetting recoverySetting = new RecoverySetting();
            recoverySetting.setOwnerId(poUuid);
            recoverySetting.setPlanId(this.getPlanId());
            recoverySetting.setRecoveryPlan(this);
            recoverySetting.setName(key);
            recoverySetting.setValue(value);
            recoverySettingSet.add(recoverySetting);
        }
        return this;
    }

    @Override
    public Map<String, String> getProps() {
        return this.getGlobalSettings();
    }

    public static boolean checkPlanType(int planType) {
        return planType == 0 || planType == 1;
    }
}

