# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.manageone_util2 import ManageOneUtil2
from utils.business.service_monitor.service_monitor import ServiceMonitorCfg
from utils.business.service_monitor.service_monitor import ServiceNodeCfg
from utils.business.service_monitor.service_monitor import del_service_m_cfg
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

from plugins.eBackup.common.util import Utils

logger.init("eBackup Config Service Monitor")


class DeleteServiceMonitor(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(DeleteServiceMonitor, self).__init__(project_id, pod_id, regionid_list)
        logger.init("eBackup connect to manageone")
        self.project_id = project_id
        self.pod_id = pod_id
        self.param_dict = Utils.init_system_params(project_id, regionid_list[0])
        self.region_id = regionid_list[0]

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.delete_service_monitor()
            return Message(200)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            return Message(500, err, err)

    def rollback(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def check_adaptation_package_version(self):
        result = ManageOneUtil2().query_adaptation_package_record(self.project_id, "eBackup", self.region_id)
        logger.info("[eBackup] Query adaptation pkg success: %s" % result[0])
        origin_version = result[0]["version"]
        return origin_version

    def delete_service_monitor(self):
        """
        标准调用接口：升级后配置工步，如果当前版本是 “1.0” 或者 “8.1.0”，则需要去删除监控模板
        :param project_id:
        :param pod_id:
        :return:
        """
        logger.info("begin to delete service monitor.")
        current_version = self.check_adaptation_package_version()
        if current_version != "1.0" and current_version != "8.1.0":
            logger.info(f"current version is {current_version}, not need delete service monitor")
            return

        datamover_ip_list = self.param_dict['eBackup_Datamover_nodes'].replace("|", ";").split(";")
        hosts = []
        templates = ["eBackup_server_template_01", "eBackup_server_template_02", "os_template"]
        for node_ip in datamover_ip_list:
            for template_id in templates:
                ebackup_node = ServiceNodeCfg(node_ip, template_id, "eBackup_log")
                hosts.append(ebackup_node)
        logger.info("new service node cfg succ.")
        service_m_cfg = ServiceMonitorCfg("eBackup", "eBackup", self.region_id, "eBackup", "IAAS", hosts)
        del_service_m_cfg(self.pod_id, service_m_cfg)
        logger.info("delete service monitor succ.")

# the code has been updated to python3.7
