# -*- coding:utf-8 -*-
from utils.business.project_condition_utils import \
    get_project_condition_boolean
from utils.business.project_condition_utils import get_project_conditions


class Condition(object):

    def __init__(self, project_id):
        self.project_id = project_id
        self.project_conditions = get_project_conditions(self.project_id)

    @property
    def is_arm(self):
        """管理面是否是ARM架构"""
        return self.project_conditions.get("manageARM")

    @property
    def is_primary(self):
        """是否是首Region"""
        return self.project_conditions.get("PrimaryRegion")

    @property
    def is_sub(self):
        """是否是新增Region"""
        return self.project_conditions.get("SubRegion")

    @property
    def is_global_con_dr(self):
        """是否是管理面跨Region容灾"""
        return self.project_conditions.get("GlobalConDR")

    @property
    def is_region_con_ha(self):
        """是否是管理面跨AZ高可用"""
        return self.project_conditions.get("RegionConHA")

    @property
    def is_csdr(self):
        """当前工程是否安装CSDR"""
        return self.project_conditions.get("CSDR")

    @property
    def is_block_dr(self):
        """CSDR保护类型是否为块存储"""
        return self.project_conditions.get("CSDR-Block")

    @property
    def is_nas_dr(self):
        """CSDR保护类型是否为文件系统"""
        return self.project_conditions.get("CSDR-Nas")

    @property
    def is_csha(self):
        """当前工程是否安装CSHA"""
        return self.project_conditions.get("CSHA")

    @property
    def is_vha(self):
        """当前工程是否安装VHA"""
        return self.project_conditions.get("VHA")

    @property
    def is_csha_installed(self):
        """当前Region是否已安装CSHA"""
        return self.project_conditions.get("InstalledCSHA")

    @property
    def is_supported_block(self):
        """当前Region是否已安装块存储容灾"""
        return self.project_conditions.get("CSDR_supported_block")

    @property
    def is_supported_nas(self):
        """当前Region是否已安装文件系统容灾"""
        return self.project_conditions.get("CSDR_supported_nas")

    @property
    def is_current_dr_installed(self):
        """当前Region是否已安装任意容灾服务"""
        return self.project_conditions.get('DRServiceInstalled')

    @property
    def is_project_deploy(self):
        """是否是部署工程"""
        return self.project_conditions.get('ProjectDeploy')

    @property
    def is_expansion_service(self):
        """是否是安装可选云服务工程"""
        return self.project_conditions.get('ExpansionAdCloudService')

    @property
    def is_expansion_service_storage(self):
        """是否是新增业务存储工程"""
        return self.project_conditions.get('ExpansionServiceStorage')

    @property
    def is_expansion_az(self):
        """是否是安装可选云服务工程"""
        return self.project_conditions.get('ExpansionAZ')

    @property
    def is_upgrade_to_hcs8(self):
        """当前环境是否从低版本升级到HCS 8.x"""
        return self.project_conditions.get("UpgradedToHCS80")

    @property
    def is_hcs_global(self):
        """当前环境是否为Global独立部署场景"""
        return self.project_conditions.get("HCSGlobal")

    @property
    def is_primary_hcs_global(self):
        """当前环境是否为Global独立部署场景"""
        return self.project_conditions.get("HCSGlobalInstalled")

    @property
    def is_general_cipher(self):
        """是否是通用加密算法"""
        return self.project_conditions.get("generalCipher")

    @property
    def is_sm_compatible(self):
        """是否是兼容商密算法"""
        return self.project_conditions.get("SMCompatible")

    @property
    def is_sm_only(self):
        """是否是只支持商密算法"""
        return self.project_conditions.get("SMOnly")

    @property
    def is_cloud_platform6(self):
        return self.project_conditions.get("CloudPlatform6")

    @property
    def is_multi_cloud_integration(self):
        return self.project_conditions.get("MultiCloudIntegration")

    @property
    def is_cloud_unify(self):
        """当前环境是多云合一"""
        return self.project_conditions.get("is_cloud_unify") or self.project_conditions.get("MultiCloudMerge")

    @property
    def is_global_region_decoupling(self):
        return self.project_conditions.get("RegionGlobal")

    @property
    def install_dr_service(self):
        """当前Region全新安装容灾服务"""
        return get_project_condition_boolean(
            self.project_id,
            "(CSDR | CSHA | VHA | eReplication)&(!DRServiceInstalled)")

    @property
    def global_con_dr_install_dr_service(self):
        """在主Region或者备Region安装容灾服务"""
        return get_project_condition_boolean(
            self.project_id,
            "(CSHA | CSDR | VHA | eReplication) & (PrimaryRegion | "
            "(SubRegion & GlobalConDR)) & (!DRServiceInstalled)")

    @property
    def vha_install_quorum(self):
        """自动化安装VHA存储仲裁软件"""
        return get_project_condition_boolean(
            self.project_id, "VHA & (TenantStorIPSAN | TenantStorFCSAN) & "
                             "install_san_quorumserver")

    @property
    def csha_install_quorum(self):
        """自动化安装CSHA存储仲裁软件"""
        return get_project_condition_boolean(
            self.project_id, "CSHA & (TenantStorIPSAN | TenantStorFCSAN) & "
                             "install_san_quorumserver")

    @property
    def expand_service_or_install_in_sub(self):
        """首Region已有服务扩容其他服务或者在新增Region安装容灾服务"""
        return get_project_condition_boolean(
            self.project_id,
            "((PrimaryRegion & (eReplication | CSDR | CSHA | VHA) & "
            "DRServiceInstalled) | (SubRegion & (eReplication | "
            "CSDR | CSHA | VHA))) & (!ExpansionServiceStorage)")

    @property
    def installed_dr_service_and_expand_csp(self):
        """容灾服务已安装后扩容CSP Agent"""
        return get_project_condition_boolean(
            self.project_id,
            "((PrimaryRegion | GlobalConDR) & CSP & InstalledeReplication)")

    @property
    def need_check_server_login(self):
        """是否需要对已有节点做登录性校验 已有服务扩服务、新增Region安装服务、已有服务扩容CSP"""
        return get_project_condition_boolean(
            self.project_id,
            "((PrimaryRegion & (eReplication | CSDR | CSHA | VHA) & "
            "DRServiceInstalled) | (SubRegion & (eReplication | CSDR | "
            "CSHA | VHA))) & (!ExpansionServiceStorage) | (ExpansionServiceStorage & CSHAStorage_TFB) | "
            "((PrimaryRegion | GlobalConDR) & CSP & "
            "InstalledeReplication)")

    @property
    def is_service_installed(self):
        """已有容灾服务安装 首Region已有服务扩服务、新增Region安装服务、VHA扩AZ、CSDR或CSHA扩存储"""
        return get_project_condition_boolean(
            self.project_id,
            "(CSDR | CSHA | VHA) & (!ExpansionServiceStorage) & "
            "((ExpansionAdCloudService & DRServiceInstalled) | SubRegion) | "
            "(eReplication & HCSGlobal & SubRegion & GlobalConDR) | "
            "(VHAStorage & ExpansionAZ_KVM) | (((CSDR & SubRegion) | "
            "CSHA) & !DRStorage_TFB_PD & ExpansionServiceStorage)")

    @property
    def need_check_cloud_quorum_login(self):
        """是否需要校验云平台仲裁节点可登陆性"""
        return get_project_condition_boolean(
            self.project_id,
            "(CSHA) & ExpansionAdCloudService & (!DRServiceInstalled)")

    @property
    def is_dr_site(self):
        """备站点安装容灾服务"""
        return get_project_condition_boolean(
            self.project_id,
            "GlobalConDR & SubRegion & (eReplication | CSDR | VHA) & "
            "(!DRServiceInstalled) & (!ExpansionServiceStorage)")

    @property
    def is_expansion_dr_service_storage(self):
        """新增灾备存储"""
        return get_project_condition_boolean(self.project_id, "!DRStorage_TFB_PD & ExpansionServiceStorage")
