# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.common.exception import HCCIException

from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.constant import VMScale
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.utils import get_project_global_scale
from plugins.eReplication.common.scale_api import API as SCALE_API


def resource_calc(project_id, pod_id):
    """
    返回本插件资源
    :param project_id:
    :param pod_id:
    :return: list
    """
    try:
        return _do_vm_resource_list(pod_id, project_id)
    except HCCIException as e:
        logger.error(str(e))
        raise e
    except Exception as e:
        logger.error(str(e))
        raise HCCIException("663600", e)


def _do_vm_resource_list(pod_id, project_id):
    logger.info(f'{Component} begin calc resource.')
    vm_resource_list = list()
    condition = Condition(project_id)
    scale = get_project_global_scale(project_id)
    cpu_num, mem, sys_disk = \
        SCALE_API.get_deploy_vm_scale(project_id, pod_id, scale)
    quorum_cpu_num = VMScale.CPU_2
    quorum_mem = VMScale.RAM_4
    quorum_sys_disk = VMScale.DISK_20
    logger.info(F"Global scale is {scale}.")
    if condition.install_dr_service and scale > 10000:
        cpu_num = VMScale.CPU_8
        mem = VMScale.RAM_16
    expansion_server_resource = \
        {
            'type': 'vm', 'host_id': None, 'cpu': cpu_num, 'mem': mem,
            'sys_disk': sys_disk, 'sys_disk_type': 'remote',
            'data_disk_total': 0, 'data_disk_type': 'remote'
        }
    expansion_quorum_resource = \
        {
            'type': 'vm', 'host_id': None, 'cpu': quorum_cpu_num,
            'mem': quorum_mem, 'sys_disk': quorum_sys_disk,
            'sys_disk_type': 'remote', 'data_disk_total': 0,
            'data_disk_type': 'remote'
        }
    # 主备Region全新安装CSDR/CSHA/VHA时，资源列表返回两台管理虚拟机资源
    if condition.global_con_dr_install_dr_service:
        vm_resource_list.extend(
            [expansion_server_resource, expansion_server_resource])
    # VHA在需要自动化安装存储仲裁软件时，资源列表返回一台仲裁虚拟机资源
    if condition.vha_install_quorum:
        vm_resource_list.append(expansion_quorum_resource)
    return vm_resource_list
