# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Params

logger.init("RegisterProduct")


class RegisterProduct(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        params = Params(self.project_id, self.pod_id)
        region_id = params.project_region_id
        console_home = params.console_home_address
        # 注册产品
        MO_API.register_product(
            self.project_id, self.pod_id, region_id, console_home,
            Component.CSDR_L)
        # 注册产品action
        MO_API.register_action(
            self.project_id, self.pod_id, region_id, console_home,
            Component.CSDR_L)
