# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Params

logger.init("ConfigDRService")


class ConfigDRService(BaseSubJob):
    """
    完成云服务配置：
    1. 创建站点
    2. 发现openstack资源
    3. 配置AZ映射
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        client = DR_API.get_dr_request_api(self.project_id, self.pod_id)
        # Step1：创建容灾站点
        site_id, uuid = DR_API.create_site(client)
        # Step2：发现OpenStack资源
        DR_API.discover_openstack(
            self.project_id, self.pod_id, client, site_id, Component.CSHA_L)
        devsn = DR_API.get_dest_device_id(
            self.project_id, self.pod_id, client, uuid)
        # 对于CSDR场景来讲, 安装从Region后, 此时需要对从Region的endpoint
        # 进行配置, 由于操作的RD是在主Region, 因此需要刷新一次设备
        DR_API.refresh_device(client, devsn)
        # Step3: 配置Region
        DR_API.config_region(self.project_id, self.pod_id, client, devsn)
        # Step4: 配置AZ与卷映射
        DR_API.config_az_volume_mapping_for_csha(
            self.project_id, self.pod_id, client, devsn)
        # Step5: 配置租户北向API
        DR_API.config_tenant_api(self.project_id, self.pod_id, client)
        # Step6: CSHA场景下要修改网卡切换开关状态
        DR_API.change_network_and_shared_switch(
            self.project_id, self.pod_id, client, devsn)
        logger.info("Switch DR mode task start.")
        DR_API.switch_dr_mode(
            self.project_id, self.pod_id,
            Params(self.project_id, self.pod_id).project_region_id)
