# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.os_api import API as OS_API

logger.init("HardeningOS")


class HardeningOS(BaseSubJob):
    """
    完成操作系统加固
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 初始化当前步骤的所有依赖参数
        nodes = Nodes(project_id, pod_id)
        arb_ip = nodes.arb_ip
        ssh_user = nodes.arb_ssh_user
        ssh_pwd = nodes.arb_ssh_pwd
        sudo_user = nodes.arb_sudo_user
        sudo_pwd = nodes.arb_sudo_pwd
        os_api = OS_API(arb_ip, ssh_user, ssh_pwd, sudo_user, sudo_pwd)
        os_api.enforce_os(user=ssh_user)
