# -*- coding:utf-8 -*-
import threading

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params
from plugins.eReplication.common.lib.thread import ExcThread
from plugins.eReplication.common.os_api import API as OS_API

logger.init("ConfigDNSAndNTP")


class ConfigDNSAndNTP(BaseSubJob):
    """
    配置NTP与DNS
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 配置DNS与NTP
        nodes = Nodes(project_id, pod_id)
        params = Params(self.project_id, self.pod_id)
        time_zone = params.time_zone
        dns_ips = Params(self.project_id, self.pod_id).dns_ips
        funcs = list()
        thread_name = threading.current_thread().name
        for host in nodes.hosts:
            os_api = OS_API(
                host, nodes.ssh_user, nodes.ssh_pwd, nodes.sudo_user,
                nodes.sudo_pwd)
            func = (
                os_api.config_dns_and_ntp, thread_name,
                (dns_ips, dns_ips, time_zone), {}
            )
            funcs.append(func)
        ExcThread.exec_func_in_thread(funcs)
