# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.arb_api import API as ARB_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result

logger.init("DockingArb")


class DockingArb(BaseSubJob):
    """
    完成eReplication仲裁服务配置
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        ARB_API.config_cloud_arb(self.project_id, self.pod_id)
