# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.constant import SFS_CERT_TYPE
from plugins.eReplication.common.constant import NOVA_CERT_TYPE
from plugins.eReplication.common.constant import MO_CERT_TYPE
from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.cert_api import API as CERT_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.dr_api import API as DR_API

logger.init("ImportCerts")


class ImportCerts(BaseSubJob):
    """
    导入MO通信证书
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 初始化当前步骤的所有依赖参数
        condition = Condition(self.project_id)
        DR_API.execute_bcm_service(self.project_id, self.pod_id, is_start=False)
        if condition.is_primary and not condition.is_current_dr_installed:
            MO_API(project_id, pod_id).get_mo_certs()
            CERT_API.import_sys_cert(self.project_id, self.pod_id, MO_CERT_TYPE)
        if condition.is_nas_dr:
            CERT_API.get_sfs_certs(self.project_id, self.pod_id)
            CERT_API.import_sys_cert(self.project_id, self.pod_id, SFS_CERT_TYPE)

        CERT_API.get_nova_cert(self.project_id, self.pod_id)
        CERT_API.import_sys_cert(self.project_id, self.pod_id, NOVA_CERT_TYPE)
        DR_API.execute_bcm_service(self.project_id, self.pod_id, is_start=True)

