# -*- coding:utf-8 -*-
import threading

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params
from plugins.eReplication.common.lib.thread import ExcThread
from plugins.eReplication.common.os_api import API as OS_API

logger.init("InitOperationSystem")


class InitOperationSystem(BaseSubJob):
    """
    初始化操作系统, 完成磁盘分区与网络设置
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        # 修改root密码
        nodes = Nodes(self.project_id, self.pod_id)
        thread_name = threading.current_thread().name
        if nodes.sudo_pwd != nodes.preset_sudo_pwd:
            reset_funcs = list()
            for host in nodes.hosts:
                reset_func = (
                    OS_API.change_system_root_pwd, thread_name,
                    (host, nodes.sudo_user, nodes.preset_sudo_pwd,
                     nodes.sudo_pwd), {}
                )
                reset_funcs.append(reset_func)
            ExcThread.exec_func_in_thread(reset_funcs)

        # 检查环境上是否已经装过eReplication, 如果装过， 则直接返回，不再初始化, 防止用户重试时再次初始化操作系统
        init_funcs = list()
        for host in nodes.hosts:
            if OS_API.check_result_in_os(
                    host, nodes.sudo_user, nodes.sudo_pwd,
                    "ls /home/ICUser/RDInstalled.xml"):
                logger.info(
                    f"Replication already installed on {host}, no need init.")
                continue
            logger.info(f"Start init system in {host}.")
            os_api = OS_API(
                host, nodes.ssh_user, nodes.ssh_pwd, nodes.sudo_user,
                nodes.sudo_pwd)
            init_func = (
                os_api.init_os, thread_name,
                (Params(self.project_id, self.pod_id).time_zone,), {}
            )
            init_funcs.append(init_func)
        ExcThread.exec_func_in_thread(init_funcs)
