#!/bin/sh

function modifyLoginDefs() {
  local fileName=/etc/login.defs
  cat $fileName | grep ^LASTLOG_ENAB &>/dev/null
  if [ $? != 0 ]; then
    echo "LASTLOG_ENAB    yes" >>$fileName
  else
    sed -i 's/^LASTLOG_ENAB.*/LASTLOG_ENAB yes/g' $fileName
  fi

  cat $fileName | grep ^PASS_MIN_LEN &>/dev/null
  if [ $? != 0 ]; then
    echo "PASS_MIN_LEN    8" >>$fileName
  else
    sed -i 's/^PASS_MIN_LEN.*/PASS_MIN_LEN 8/g' $fileName
  fi

  cat $fileName | grep ^PASS_MAX_DAYS &>/dev/null
  if [ $? != 0 ]; then
    echo "PASS_MAX_DAYS    90" >>$fileName
  else
    sed -i 's/^PASS_MAX_DAYS.*/PASS_MAX_DAYS 90/g' $fileName
  fi

  cat $fileName | grep ^PASS_MIN_DAYS &>/dev/null
  if [ $? != 0 ]; then
    echo "PASS_MIN_DAYS    0" >>$fileName
  else
    sed -i 's/^PASS_MIN_DAYS.*/PASS_MIN_DAYS 0/g' $fileName
  fi

  cat $fileName | grep ^PASS_WARN_AGE &>/dev/null
  if [ $? != 0 ]; then
    echo "PASS_WARN_AGE    15" >>$fileName
  else
    sed -i 's/^PASS_WARN_AGE.*/PASS_WARN_AGE 15/g' $fileName
  fi
}

function modifyProfile() {
  local line0=$(cat /etc/profile | grep -wn ^export | grep -w TMOUT | sed -n '1p' | awk -F: '{print $1}')
  if [ -z "$line0" ]; then
    echo "export TMOUT=60" >>/etc/profile
  else
    sed -i "${line0}s/.*/export TMOUT=60/" /etc/profile
  fi

  local line=$(cat /etc/profile | grep -wn ^umask | sed -n '1p' | awk -F: '{print $1}')
  if [ -z "$line" ]; then
    echo "umask 027" >>/etc/profile
  else
    sed -i "${line}s/.*/umask 027/" /etc/profile
  fi
}

function denyRootLogin() {
  local sshdFile=/etc/ssh/sshd_config
  cat "$sshdFile" | grep -w "PermitRootLogin" | sed 's/ //g' | grep ^PermitRootLogin &>/dev/null
  if [ $? != 0 ]; then
    echo "PermitRootLogin no" >>$sshdFile
  else
    sed -i 's/PermitRootLogin.*/PermitRootLogin no/g' $sshdFile
  fi
}

function configUsePrivilegeSeparation() {
  local sshdFile=/etc/ssh/sshd_config
  cat "$sshdFile" | grep -w "UsePrivilegeSeparation" | sed 's/ //g' | grep ^UsePrivilegeSeparation &>/dev/null
  if [ $? != 0 ]; then
    echo "UsePrivilegeSeparation yes" >>$sshdFile
  else
    sed -i 's/UsePrivilegeSeparation.*/UsePrivilegeSeparation yes/g' $sshdFile
  fi
}

function hardeningRootAuthentication() {
    local sudoFile=/etc/pam.d/sudo
    cat "$sudoFile" | grep -E "account.*include.*system-auth" | grep ^account &>/dev/null
    if [ $? == 0 ]; then
      sed -i '/account.*include.*system-auth/d' $sudoFile
    fi

    cat "$sudoFile" | grep -E "account.*required.*pam_unix.so" | grep ^account &>/dev/null
    if [ $? != 0 ]; then
      echo "account     required      pam_unix.so" >> $sudoFile
    fi

    cat "$sudoFile" | grep -E "account.*sufficient.*pam_localuser.so" | grep ^account &>/dev/null
    if [ $? != 0 ]; then
      echo "account     sufficient    pam_localuser.so" >> $sudoFile
    fi

    cat "$sudoFile" | grep -E "account.*sufficient.*pam_succeed_if.so uid < 1000 quiet" | grep ^account &>/dev/null
    if [ $? != 0 ]; then
      echo "account     sufficient    pam_succeed_if.so uid < 1000 quiet" >> $sudoFile
    fi

    cat "$sudoFile" | grep -E "\-account.*[default=bad success=ok user_unknown=ignore].*pam_sss.so" | grep '^-account' &>/dev/null
    if [ $? != 0 ]; then
      echo "-account     [default=bad success=ok user_unknown=ignore] pam_sss.so" >> $sudoFile
    fi

    cat "$sudoFile" | grep -E "account.*required.*pam_permit.so" | grep ^account &>/dev/null
    if [ $? != 0 ]; then
      echo "account     required      pam_permit.so" >> $sudoFile
    fi
}

function updateSysctlParam() {
  local key=$1
  local value=$2

  local number=$(cat /etc/sysctl.conf | sed 's/ //g' | grep -n ^"${key}=" | awk -F: '{print $1}')
  if [ -z "$number" ]; then
    echo "${key}=${value}" >>/etc/sysctl.conf
  else
    sed -i "${number}s/.*/${key}=${value}/" /etc/sysctl.conf
  fi
}

function other_reinforece() {
  if [ ! -f "/etc/sysctl.conf" ]; then
    touch /etc/sysctl.conf
    chmod 600 /etc/sysctl.conf
  fi
  updateSysctlParam net.ipv4.conf.default.secure_redirects 0
  updateSysctlParam net.ipv4.conf.all.secure_redirects 0
  updateSysctlParam net.ipv4.conf.default.send_redirects 0
  updateSysctlParam net.ipv4.conf.all.send_redirects 0
  updateSysctlParam net.ipv4.conf.default.accept_redirects 0
  updateSysctlParam net.ipv4.conf.all.accept_redirects 0
  updateSysctlParam net.ipv4.ip_forward 0
  updateSysctlParam net.ipv4.conf.all.accept_source_route 0
  updateSysctlParam net.ipv4.conf.default.accept_source_route 0
  updateSysctlParam net.ipv4.tcp_max_syn_backlog 4096
  sysctl -p 1>/dev/null

  systemctl disable firewalld
  systemctl stop firewalld
  cat /etc/rc.d/rc.local | grep -w timestamp-request &>/dev/null
  if [ $? != 0 ]; then
    echo "iptables -I INPUT -p icmp --icmp-type timestamp-request -j DROP" >>/etc/rc.d/rc.local
  fi
  cat /etc/rc.d/rc.local | grep -w timestamp-reply &>/dev/null
  if [ $? != 0 ]; then
    echo "iptables -I OUTPUT -p icmp --icmp-type timestamp-reply -j DROP" >>/etc/rc.d/rc.local
  fi
  iptables-save >/etc/sysconfig/iptables

  echo 1 >/proc/sys/net/ipv4/tcp_syncookies
}

function modify_file_permissions() {
  chmod 644 /etc/passwd
  chmod 000 /etc/shadow
  chmod 644 /etc/group
}

function main() {
  modifyLoginDefs
  modifyProfile
  other_reinforece
  denyRootLogin
  configUsePrivilegeSeparation
  hardeningRootAuthentication
  modify_file_permissions
  service sshd restart
  rm -fr /var/eReplication &>/dev/null
  if [ "${resetFlag}" == "True" ]; then
    chage -d0 ${userName}
  fi
  echo "reinforce successfully."
  exit 0
}

userName=$1
resetFlag=$2
echo "$userName" | grep -wE "DRManager|quorumuser" &>/dev/null
if [ $? != 0 ]; then
  echo "Reinforce OS failed, the input user name[$userName] is not support."
  exit 1
fi

echo "$resetFlag" | grep -wE "True|False" &>/dev/null
if [ $? != 0 ]; then
  echo "Reinforce OS failed, the input reset flasg[$resetFlag] is not support."
  exit 1
fi
main
exit $?
