from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient


class KarborHealth(node_installer.ThreadInstaller):
    def __init__(self, project_id, pod_id):
        self.karbor_util = KarborUtil(project_id, pod_id)
        nod_list = self.karbor_util.get_karbor_node_list()
        super(KarborHealth, self).__init__(nod_list)
        self.error_service = list()
        self.error_object = list()
        self.ssh_client = SshClient()

    def check_service(self, ssh_client):
        check_service_list_len = 6
        check_result_index = 3
        instanceid_index = 1
        cmds = "source /opt/huawei/dj/inst/utils.sh;show_service --node $HOSTNAME | sed 's/ //g'"
        result = self.ssh_client.ssh_exec_command_return(ssh_client, cmds)
        if not self.ssh_client.is_ssh_cmd_executed(result):
            self.error_service.append("Show service failed.")
            return False
        for item_str in result:
            item_list = item_str.split("|")
            if len(item_list) == check_service_list_len and item_list[check_result_index].lower() == "fault":
                self.error_service.append(item_list[instanceid_index])
                return False
        return True

    def check_karbor(self, ssh_client):
        check_items_minimum_number = 10
        check_item_list_len = 7
        check_result_index = 3
        object_index = 1
        operation_index = 2
        cmds = "source /opt/huawei/dj/inst/utils.sh;check_karbor_connect | sed 's/ //g'"
        result = self.ssh_client.ssh_exec_command_return(ssh_client, cmds)
        if not self.ssh_client.is_ssh_cmd_executed(result):
            self.error_object.append("check_karbor_connect")
            return False
        if len(result) < check_items_minimum_number:
            self.error_object.append("check_karbor_connect")
            return False
        for item_str in result:
            item_list = item_str.split("|")
            if len(item_list) == check_item_list_len and item_list[check_result_index].lower() == "error":
                self.error_object.append(f"{item_list[object_index]}-{item_list[operation_index]}")
                return False
        return True

    def install_thread(self, node):
        karbor_client = self.ssh_client.get_ssh_client(node)
        if self.check_karbor(karbor_client) and self.check_service(karbor_client):
            self.install_result[node.node_ip] = True
        self.ssh_client.ssh_close(karbor_client)

    def check_thread(self, node):
        self.check_result[node.node_ip] = True

    def rollback_thread(self, node):
        self.rollback_result[node.node_ip] = True
