import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.util import check_url_param
from plugins.CSBS.scripts.deploy.karbor.cbs_installer.karbor_cpshelper import CPSInfo
from plugins.CSBS.scripts.deploy.karbor.cbs_installer.karbor_cpshelper import CpsHelper

logger.init("KarborAZ")


class ConfigNeutronEndpointsToKarbor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ConfigNeutronEndpointsToKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        cps_node = CPSInfo(self.pod_id).get_cps_node()
        self.cps_helper = CpsHelper(cps_node)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._config_neutron_endpoint()
        except Exception as err:
            logger.error(f"Execute error:{err}.")
            return Message(500, HCCIException("640049"))
        logger.info('Config neutron endpoints success.')
        return Message(200)

    def _config_neutron_endpoint(self):
        karbor_client = SshClient()
        neutron_endpoint = self.cps_helper.get_neutron_endpoint()
        if not neutron_endpoint:
            raise Exception("Param:neutron_endpoint is None.")
        logger.info(f'Get param neutron_endpoint: {neutron_endpoint}.')
        check_url_param(neutron_endpoint)

        logger.info(f"Start to set neutron endpoints.")
        cmd = f"source /opt/huawei/dj/inst/utils.sh;set_karbor_endpoints --neutron_endpoint {neutron_endpoint}"
        ssh_client = karbor_client.get_ssh_client(self.karbor_util.get_karbor_node_list()[0])
        result = karbor_client.ssh_send_command_expect(ssh_client, cmd, "successful", 30)
        karbor_client.ssh_close(ssh_client)
        if karbor_client.failed_to_return(result, "successful", ssh_client):
            raise Exception("Failed to config neutron endpoints.")
