import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common import ebackup_util
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.util import set_ebackup_server

logger.init("KarborAZ")


class ConfigEbackupAZMapToKarbor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ConfigEbackupAZMapToKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.ebackup_util = ebackup_util.EBackupUtil(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._exebackup()
        except Exception as err:
            logger.error(f"Execute error:{err}.")
            return Message(500, HCCIException("640049"))
        logger.info('Config ebackup server success.')
        return Message(200)

    def _exebackup(self):
        karbor_client = SshClient()
        ebackup_az = self.ebackup_util.get_ebackup_az()
        logger.info(f'Get param ebackup_az: {ebackup_az}.')

        ebackup_management_ip = self.ebackup_util.get_ebackup_management_ip()
        logger.info(f'Get param ebackup_management_ip: {ebackup_management_ip}.')

        ebackup_auth_account = self.ebackup_util.get_ebackup_userpwd()
        logger.info(f'Get param ebackup_userpwd: {ebackup_auth_account}.')

        logger.info(f"Start to config ebackup server.")
        cmd = f"source /opt/huawei/dj/inst/utils.sh;" \
              f"set_ebackup_server --op add --ebackup_url {ebackup_management_ip} --az {ebackup_az}"
        ssh_client = karbor_client.get_ssh_client(self.karbor_util.get_karbor_node_list()[0])
        try:
            result = set_ebackup_server(ssh_client, cmd, ebackup_auth_account.account_pwd, karbor_client)
        except Exception as error:
            raise Exception(f"Failed to config ebackup server.{str(error)}") from error
        logger.info(f"set eBackup server success: {result}.")
        karbor_client.ssh_close(ssh_client)
        if not result:
            raise Exception("Failed to config ebackup server.")
