import time

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import cbs_configureset, cbs_fileupload

logger.init("CSBS")


class UploadPackage(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(UploadPackage, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id

    def execute(self, project_id, pod_id, regionid_list=None):
        retry = 30
        logger.info('Start writing params configuration to sys.ini')
        try:
            if not cbs_configureset.ConfigureSet(project_id, pod_id).install():
                return Message(500, HCCIException("640039"))
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, HCCIException("640039"))
        logger.info('Succeed writing params configuration to sys.ini')
        # 虚拟机创建成功后,镜像未完全启动, 可能远程连接不上, 循环重试
        retry_count = 0
        while retry_count <= retry:
            logger.info('Start to upload Installing packages to three karbor nodes')
            try:
                if cbs_fileupload.FileUpload(project_id, pod_id).install(True):
                    logger.info('Succeed to upload Installing packages')
                    break
                else:
                    raise Exception('Failed to upload Installing packages')
            except Exception as err:
                retry_count += 1
                logger.error('ErrMsg:{} ,Sleep 60sec to retry, retry:[{}]'.format(err, retry_count))
                time.sleep(60)
                continue
        else:
            logger.error('Timeout!  Failed uploading Installing packages to karbor vms')
            return Message(500, HCCIException(640040))
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            rollback_result = cbs_fileupload.FileUpload(project_id, pod_id).rollback()
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, HCCIException("640040"))
        if not rollback_result:
            return Message(500, HCCIException("640040"))

        try:
            rollback_result = cbs_configureset.ConfigureSet(project_id, pod_id).rollback()
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, HCCIException("640039"))
        if not rollback_result:
            return Message(500, HCCIException("640039"))
        return Message(200)
