import utils.common.log as logger
from utils.Logic.ServerOperate import ServerOperate
from utils.business.vm_util import PublicServiceOM
from utils.common.fic_base import ToolClient
from utils.common.message import RESULT_CODE
from utils.common.openstack_host import get_openstack_info_by_pod_id

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.project_set import project_preset


class KarborProxyMigrationVM(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(KarborProxyMigrationVM, self).__init__(project_id, pod_id, regionid_list)
        logger.init("KarborProxyMigrationVM")
        self._project_id = project_id
        self._pod_id = pod_id

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start migration vm process.")
        om_util = PublicServiceOM()
        server_id = self.__get_migration_vm_id()
        logger.info(f"Get CSBS-KarborProxy-02 vm id return {server_id}.")
        om_util.batch_migration_vm(self._pod_id, server_id)
        logger.info("Migration vm process finished.")

    def retry(self, project_id, pod_id, regionid_list=None):
        rollback_result = self.rollback(project_id, pod_id)
        if rollback_result.status_code == RESULT_CODE['ERROR']:
            return rollback_result
        else:
            return self.execute(project_id, pod_id)

    def __get_migration_vm_id(self):
        auth_provider = get_openstack_info_by_pod_id(self._pod_id)
        host_and_tool = (auth_provider, ToolClient.OPENSTACK_COMPUTE)
        vm_operate = ServerOperate()
        vm_name = "CSBS-KarborProxy-02"
        vm_list = vm_operate.get_servers_by_name(
            server_name=vm_name, host_and_tool=host_and_tool)
        for vm_info in vm_list['servers']:
            if vm_info['name'] == vm_name or vm_info['name'].startswith(vm_name):
                return [vm_info['id']]
        raise Exception(f"Get vm id failed, dest vm name is {vm_name}.")
