import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.ssh_util import Ssh

from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxyDPAInfos
from plugins.CSBS.scripts.deploy.karborproxy.config.shell_cmd import ShellCmd
from plugins.CSBS.scripts.deploy.karborproxy.config.ssh_cmd import SShCmd

logger.init("KarborProxy Connection Karbor And DPA")


class DpaConnectKarbor:
    def __init__(self, project_id, pod_id):
        self.agent_proxy = AgentProxyDPAInfos(project_id, pod_id)
        self.karbor_version = None
        self.karbor_node = None
        self.ssh = SShCmd()
        self.ssh_obj = Ssh()

    def config(self):
        if not self.karbor_node or not self.karbor_version:
            raise HCCIException(f'karbor node: {self.karbor_node}, karbor version: {self.karbor_version}, please check')
        self._config_zone_az_info_to_karbor()
        self._write_dpa_info_to_karbor()

    def _config_zone_az_info_to_karbor(self):
        if self.agent_proxy.az_related_to_dpa:
            business_zone, ha_zone = self.agent_proxy.get_dpa_az_zone()
            if ha_zone:
                cmd = f'source /opt/huawei/dj/inst/utils.sh;' \
                      f'set_res_mgr_configs --business_zone {business_zone} --ha_zone {ha_zone}'
            else:
                cmd = f'source /opt/huawei/dj/inst/utils.sh;set_res_mgr_configs --business_zone {business_zone}'
            self.ssh.ssh_cmd_to_karbor(self.karbor_node, cmd)

    def _write_dpa_info_to_karbor(self):
        logger.info("Start write dpa info to karbor.")
        dpa_business_address_list = self.agent_proxy.dpa_business_address_list
        dpa_cluster_address_list = self.agent_proxy.dpa_cluster_address_list
        dpa_info_list = self.agent_proxy.dpa_info_list

        if len(dpa_business_address_list) != len(dpa_cluster_address_list):
            raise HCCIException('dpa business url or cluster address has error length, please check.')

        for dpa_info in dpa_info_list:
            if len(dpa_info) != len(dpa_business_address_list):
                raise HCCIException('dpa account info has error length, please check.')

        for index, address in enumerate(zip(dpa_business_address_list, dpa_cluster_address_list)):
            dpa_account_info = [dpa_info[index] for dpa_info in dpa_info_list]
            [ip_port_zone, dpa_cluster_address] = address
            zone = None
            ip_port = ip_port_zone
            if isinstance(ip_port_zone, tuple) and len(ip_port_zone) == 2:
                ip_port, zone = ip_port_zone
            if ip_port is None:
                raise HCCIException('dpa business url is error, please check.')
            cmd = ShellCmd.karbor_conn_dpa_cmd % (ip_port, dpa_cluster_address)
            if zone:
                cmd = f'{cmd} --zone {zone}'
            if len(ip_port.split(":")) != 2:
                raise HCCIException('dpa business url is error, please check.')
            dpa_ip, _ = ip_port.split(":")
            cmd_delete = "source /opt/huawei/dj/inst/utils.sh;" \
                         f"get_res_mgr_backend | grep {dpa_ip}  && get_res_mgr_backend | grep  {dpa_ip} |" \
                         " awk -F '|' '{print $5}' | sed 's/ //g' | xargs set_res_mgr_backend --action delete" \
                         f" --dpa_business_float  {ip_port} --dpa_cluster  {dpa_cluster_address} --proxy_port"

            self.ssh.ssh_cmd_to_karbor(self.karbor_node, cmd_delete, ['0', '1'])
            self.ssh.ssh_connect_karbor(
                self.karbor_node,
                self.karbor_version,
                cmd,
                dpa_account_info
            )