import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.iam_util import IamUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class RegisterIAMAccount(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(RegisterIAMAccount, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.iam_util = IamUtil(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._register_iam_account()
        except Exception as err:
            logger.error(f"Execute error:{str(err)}.")
            return Message(500, HCCIException(640009, str(err)))
        return Message(200)

    def _register_iam_account(self):
        # 创建 karbor op_service IAM 账号
        self.iam_util.create_op_service_account()
        # 创建角色
        self.iam_util.create_role()
        # 创建 karbor op_svc IAM 账号
        self.iam_util.create_op_svc_account()
