import re

from utils.common.error.hcci_error_code import get_code_msg
import utils.common.log as logger


class BaseMsg:
    error_log = "error,info:key is %s,value is %s"
    error_msgs = {}
    error_code = 650001

    def __init__(self, key=None, value=None, error_code=None):
        # The value of the password field is set to ****.
        value = '****' if 'pass' in str(key).lower() else value
        self.msg = self.get_msg(key, value)
        if key:
            self.error_msgs.update({key: self.msg})
        if error_code:
            self.error_code = error_code

    def get_msg(self, key, value):
        """
          When the error description is configured in the report_cn.ini file,
          no %s is directly printed. There is a %s format value,
          Two key values are formatted.
        """
        code_msg = get_code_msg(self.error_code)
        nums = self.sum_count(code_msg)
        if nums == 0:
            logger.error(code_msg)
        if nums == 1:
            code_msg = code_msg % key
            logger.error(self.error_log % key)
        if nums == 2:
            code_msg = code_msg % (key, value)
            logger.error(self.error_log % (key, value))
        return code_msg

    @staticmethod
    def sum_count(string, count_str='%s'):
        return len(re.findall(count_str, string))

    def to_raise(self):
        raise Exception(self.msg)
