import utils.common.log as logger
from utils.business.service_monitor.service_monitor import AuthProvider
from utils.business.service_monitor.service_monitor import Host
from utils.business.service_monitor.service_monitor import deploy_agent
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxy

logger.init("KarborProxy install ic agent")


class InstallICAgent(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.agent_proxy = AgentProxy(project_id, pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._install_icagent(pod_id)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error("Failed to install IC Agent" + str(err))
            return Message(500, err, err)
        logger.info("Success to install IC Agent")
        return Message(200)

    def _install_icagent(self, pod_id):
        ip0 = self.agent_proxy.karbor_proxy_ip0
        ip1 = self.agent_proxy.karbor_proxy_ip1
        ip_list = list((ip0, ip1))
        agent_hosts = []
        for _ip in ip_list:
            ansible_ssh_ip = _ip
            ansible_ssh_port = 22
            agent_listen_address = _ip
            agent_client_address = _ip
            host = Host(ansible_ssh_ip, ansible_ssh_port, agent_listen_address, agent_client_address)
            agent_hosts.append(host)
        dmk_ip = self.agent_proxy.agent_dmk_ip
        dmk_user_name = self.agent_proxy.agent_dmk_user_name
        dmk_pwd = self.agent_proxy.agent_dmk_pwd
        dmk_info = AuthProvider(dmk_ip, 8443, dmk_user_name, dmk_pwd)
        logger.info("Begin to install IC Agent")
        result = deploy_agent(pod_id, dmk_info, agent_hosts, "dpamanager", "su")
        if not result:
            logger.error("Failed to install IC Agent")
            raise HCCIException(653009)
