import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob


logger.init("CSBS-VBS")


class OffAutoBak(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(OffAutoBak, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """turn auto backup off

        """
        logger.info("Start to turn off Karbor Automatic Backup.")
        try:
            self.karbor_operation.change_operation_service(tar_status="stop")
        except Exception as err:
            logger.error(f"Failed to turn off Karbor automatic backup, reason:{str(err)}.")
            return Message(500, HCCIException(645019))
        logger.info("Turn off automatic backup function succeed.")
        return Message(200)
