import os

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.params import ParamsTools
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.upgrade.karborproxy_params import ProxyDMKClient
from plugins.CSBS.common.upgrade.params import ParamsStore


logger.init("KarborProxy")


class UploadKarborProxyPkgToDMK(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadKarborProxyPkgToDMK, self).__init__(project_id, pod_id, regionid_list)
        self.karborproxy = KarborProxyOperation(self.project_id)
        self.params_tools = ParamsTools(self.project_id)
        self.proxy_dmk_client = ProxyDMKClient(self.project_id, self.pod_id, self.regionid_list)
        self.params = ParamsStore(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):

        pkg_suffix = "Proxy-x86_64.zip" if self.params_tools.is_x86_scene else "Proxy-aarch64.zip"
        pkg_root_path, pkg_name = self.params_tools.get_pkg_path_and_pkg_name(pkg_suffix)
        pkg_version = self.karborproxy.get_karborproxy_pkg_version()
        target_version = self.params.get_upgrade_path_version().get("target_version")
        if pkg_version != target_version:
            raise Exception("The karborproxy package is not the expected one."
                            "Please check and upload karborproxy package of the correct version.")

        pkg_path = os.path.join(pkg_root_path, pkg_name)
        try:
            self.proxy_dmk_client.upload_pkg_to_dmk(pkg_path, self.pod_id)
        except Exception as ex:
            logger.error(ex)
            return Message(500, HCCIException(645004))
        logger.info("Upload KarborProxy upgrade package to DMK successfully.")
        return Message(200)

# the code has been updated to python3.7
