#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

CONF_FILE="$1"
UTIL_CONF=${LINE_ROOT}/cfg/util.conf

# 获取当前节点IP,并判断当前节点是否存在部署文件中
node_list_str=$(grep -v "[SYSTEM]" "${CONF_FILE}" | grep -v "[FEATURE]" | grep "\[.*\]" | sed -r 's/(\[|\])//g')
while read -r ip;do
    if ip a | grep "${ip}/";then
        manage_ip="${ip}"
        break
    fi
done <<< "${node_list_str}"
[[ -z ${manage_ip} ]] && CHECK_RESULT 1 "current node not in configuration."


# 获取当前节点IP配置信息
manage_ip_netmask=$(read_ini_file manage_ip_netmask SYSTEM "${CONF_FILE}")
gaussdb_float_ip=$(read_ini_file gaussdb_float_ip SYSTEM "${CONF_FILE}")
haproxy_float_ip=$(read_ini_file haproxy_float_ip SYSTEM "${CONF_FILE}")
ntp_server_ip=$(read_ini_file ntp_server_ip SYSTEM "${CONF_FILE}")
dns_ip=$(read_ini_file dns_ip SYSTEM "${CONF_FILE}")
host_name=$(read_ini_file hostname "${manage_ip}" "${CONF_FILE}")
time_zone=$(read_ini_file timezone SYSTEM "${CONF_FILE}")

function CheckIPisinsame_net_segment()
{
    echo "$1" | xargs | grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null;
    CHECK_RESULT $? "Check failed. The IP address ($1) is invalid."
    echo "$2" | xargs | grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null;
    CHECK_RESULT $? "Check failed. The IP address ($1) is invalid."
    echo "$3" | xargs | grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null;
    CHECK_RESULT $? "Check failed. The IP address ($1) is invalid."
    node_ip="$1"
    float_ip="$2"
    float_netmask="$3"
    netmask_a=$(echo "${float_netmask}" | awk -F. '{print $1}')
    netmask_b=$(echo "${float_netmask}" | awk -F. '{print $2}')
    netmask_c=$(echo "${float_netmask}" | awk -F. '{print $3}')
    netmask_d=$(echo "${float_netmask}" | awk -F. '{print $4}')
    log_info "Checking  float_netmask ${netmask_a} ${netmask_b} ${netmask_c} ${netmask_d}"
    float_ip_a=$(echo "${float_ip}" | awk -F. '{print $1}')
    float_ip_b=$(echo "${float_ip}" | awk -F. '{print $2}')
    float_ip_c=$(echo "${float_ip}" | awk -F. '{print $3}')
    float_ip_d=$(echo "${float_ip}" | awk -F. '{print $4}')
    log_info "Checking  float_ip ${float_ip_a} ${float_ip_b} ${float_ip_c} ${float_ip_d}"
    ip_a=$(echo "${node_ip}" | awk -F. '{print $1}')
    ip_b=$(echo "${node_ip}" | awk -F. '{print $2}')
    ip_c=$(echo "${node_ip}" | awk -F. '{print $3}')
    ip_d=$(echo "${node_ip}" | awk -F. '{print $4}')
    log_info "Checking  node_ip ${ip_a} ${ip_b} ${ip_c} ${ip_d}"
    a_fvalue=$((float_ip_a&netmask_a))
    b_fvalue=$((float_ip_b&netmask_b))
    c_fvalue=$((float_ip_c&netmask_c))
    d_fvalue=$((float_ip_d&netmask_d))
    a_value=$((ip_a&netmask_a))
    b_value=$((ip_b&netmask_b))
    c_value=$((ip_c&netmask_c))
    d_value=$((ip_d&netmask_d))
    log_info "Checking float_ip&mask ${a_fvalue} ${b_fvalue} ${c_fvalue} ${d_fvalue} IP is OK!"
    log_info "Checking ip&mask ${a_value} ${b_value} ${c_value} ${d_value} IP is OK!"
    [[ "${a_fvalue}" -ne "${a_value}" ]] &&  CHECK_RESULT 1 "float_ip and ip is not in same net segment."
    [[ "${b_fvalue}" -ne "${b_value}" ]] &&  CHECK_RESULT 1 "float_ip and ip is not in same net segment."
    [[ "${c_fvalue}" -ne "${c_value}" ]] &&  CHECK_RESULT 1 "float_ip and ip is not in same net segment."
    [[ "${d_fvalue}" -ne "${d_value}" ]] &&  CHECK_RESULT 1 "float_ip and ip is not in same net segment."
    log_info "float_ip and ip is in same net segment."
}

function _check_floatip_net_segment()
{
    CheckIPisinsame_net_segment "${manage_ip}" "${haproxy_float_ip}" "${manage_ip_netmask}"
    CheckIPisinsame_net_segment "${manage_ip}" "${gaussdb_float_ip}" "${manage_ip_netmask}"
    log_info "Successfully checked that the floating IP address and static IP address are not in the same network segment."
}


function _check_ini_hostname()
{
    echo "${host_name}" | xargs | grep "^[A-Za-z0-9\-]*$" > /dev/null
    CHECK_RESULT $? "Check failed. The hostname \"${host_name}\" is the same as other nodes."
    hostname "${host_name}"
    echo "${host_name}" > /etc/hostname
    echo "${host_name}" > /etc/HOSTNAME
    sed -i "/${manage_ip}.*${host_name}/d" /etc/hosts
    echo "${manage_ip} ${host_name}" >> /etc/hosts
}

function _check_ini_timezone()
{
    if [[ -z "${time_zone}" ]] || [[ "${time_zone}" = "None" ]];then
        CHECK_RESULT 1 "Check failed. Achieve the parameter of timezone from configuration file failed."
    fi
    timezoneFile="/usr/share/zoneinfo/${time_zone}"
    spaces_num=$(echo "${timezoneFile}" | xargs | grep -c " ")
    if [[ ! -f "${timezoneFile}" ]];then
        CHECK_RESULT 1 "Check failed. The timezone does not exist in current operating system."
    fi
    if [[ "${spaces_num}" -ne 0 ]];then
        CHECK_RESULT 1 "Check failed. The timezone does not exist in current operating system."
    fi
    # Set system timezone
    rm -f /etc/localtime && ln -sf "${timezoneFile}" /etc/localtime
    hwclock -w
    log_info "Check timezone in ini file OK."
}


function _check_ip_for_3rdplane()
{
      while read -r ping_ip;do
          if [[ "${ping_ip}" == "${manage_ip}" ]] || [[ "${ping_ip}" == "${gaussdb_float_ip}" ]];then
              continue
          fi
          ping -I "${manage_ip}" -c 2 -w 3 "${ping_ip}" >/dev/null
          CHECK_RESULT $? "Exec command karbor_ping -I ${manage_ip} -c 2 -w 3 ${ping_ip} failed."
     done <<< "${node_list_str}"
     log_info "Successfully karbor_ping static IP address in node"
}

function _check_dns_ip()
{
    if [[ -z "${dns_ip}" ]] || [[ "${dns_ip}" = "None" ]]; then
        log_info "no dns_ip in the sys.ini"
        return 0
    fi
    IFS="," read -r -a ip_list <<< "${dns_ip}"
    for ip in "${ip_list[@]}";do
        ping -I "${manage_ip}" -c 2 -w 3 "${ip}" >/dev/null
        CHECK_RESULT $? "Check failed. The dns ip of ($ip) is invalid."
    done
    log_info "The dns ip of (${dns_ip}) is valid."
    return 0
}

function _check_ntp_ip()
{
    if [[ -z "${ntp_server_ip}" ]] || [[ "${ntp_server_ip}" = "None" ]]; then
        log_info "no ntp_server_ip in the sys.ini"
        return 0
    fi
    IFS="," read -r -a ip_list <<< "${ntp_server_ip}"
    for ip in "${ip_list[@]}";do
        ping -I "${manage_ip}" -c 2 -w 3 "${ip}" >/dev/null
        CHECK_RESULT $? "Check failed. The ntp ip of ($ip) is invalid."
    done
    log_info "The ntp ip of (${ntp_server_ip}) is valid."
}

function _check_pwd()
{
    line=$(grep -n '\[SYSTEM\]' "${CONF_FILE}"|cut -d: -f1)
    gaussdb_admin_pwd_en=$(get_pwd "gaussdb_admin_pwd" "${UTIL_CONF}")
    gaussdb_admin_pwd_info="gaussdb_admin_pwd=${gaussdb_admin_pwd_en}"
    if ! (grep gaussdb_admin_pwd "${CONF_FILE}");then
        sed -i "${line}a${gaussdb_admin_pwd_info}" "${CONF_FILE}"
    fi
    default_user_pwd_en=$(get_pwd "default_user_pwd" "${UTIL_CONF}")
    default_user_pwd_info="default_user_pwd=${default_user_pwd_en}"
    if ! (grep default_user_pwd "${CONF_FILE}");then
        sed -i "${line}a${default_user_pwd_info}" "${CONF_FILE}"
    fi
}

function _check_listen_address()
{
    ListenAddress="$(grep "^ListenAddress " /etc/ssh/sshd_config)"
    if [[ "${ListenAddress}" != "ListenAddress ${manage_ip}" ]]; then
        sed -i "/${ListenAddress}/d" /etc/ssh/sshd_config
        echo "ListenAddress ${manage_ip}" >> /etc/ssh/sshd_config
    fi
    if ! (grep "^interface listen ${manage_ip}" /etc/ntp.conf);then
       echo "interface listen ${manage_ip}" >> /etc/ntp.conf
    fi
}

_check_pwd
_check_listen_address
_check_ip_for_3rdplane
_check_ini_hostname
_check_ini_timezone
_check_floatip_net_segment
_check_dns_ip
_check_ntp_ip
exit 0