#!/bin/bash
source "$(dirname "${BASH_SOURCE[0]}")"/run_utils.sh
######################################################################
# 功能说明  : 安装场景默认配置证书有效期
######################################################################
DEF_CERT_VALIDITY_PERIOD=36135
######################################################################
# 功能说明  : 安装后修改权限
# 该方法可以修改指定名称文件，默认*
# 修改后属主openstack:openstack 文件600
######################################################################
function set_modify_permission()
{
    [[ -n "$2" ]] && name="$2" || name="*"
    target=$(realpath "$1")
    modify_permission=$(find "${target}" -type f -name "${name}")
    while read -r file;do
        [[ -z "${file}" ]] && continue
        chown -h openstack:openstack "${file}"
        chmod 600 "${file}"
    done <<< "${modify_permission}"
}
######################################################################
# 功能说明  : 安装顶级目录权限，
# 该方法仅修改安装和日志顶级目录权限
# 修改后属主root:root 目录750
######################################################################
function set_install_permission()
{
    mkdir -p /opt/huawei /var/log/huawei
    chown -h root:root /opt/huawei /var/log/huawei
    chmod 755 /opt/huawei /var/log/huawei
}
######################################################################
# 功能说明  : 安装后通用权限，
# 该方法仅修改非openstack用户的文件
# 目录时回递归修改目录下所有文件和目录
# 修改后属主openstack:openstack 目录700、可执行文件500、文件400
######################################################################
function set_common_permission()
{
    target=$(realpath "$1")
    common_permission=$(find "${target}" ! -user openstack)
    while read -r file;do
        [[ -z "${file}" ]] && continue
        chown -h openstack:openstack "${file}"
        if [[ -d "${file}" ]];then
            chmod 700 "${file}"
        elif [[ -x "${file}" ]];then
            chmod 500 "${file}"
        elif [[ -f "${file}" ]];then
            chmod 400 "${file}"
        fi
    done <<< "${common_permission}"
}
######################################################################
# 功能说明  : 创建软连接
# 入    参:    :  path
######################################################################
function create_link()
{
    chmod 500 "$1"
    if [[ $# -eq 1 ]];then
        name=$(basename "${1%%.*}")
    else
        name="$2"
    fi
    rm -f "/opt/huawei/dj/sbin/${name}"
    ln -sf "$1" "/opt/huawei/dj/sbin/${name}"
}
######################################################################
# 功能说明  : 安装sudo提权配置文件
# 参数 1: 配置文件
######################################################################
function install_sudo_conf()
{
    /usr/bin/cp -f "$1" /etc/sudoers.d
    file_name=$(basename "$1")
    chmod 400 "/etc/sudoers.d/${file_name}"
}
######################################################################
# 功能说明  : 安装运维脚本
# 参数 1: 运维脚本 //要求该脚本已配置运维帐号提权
######################################################################
function install_manager_tools()
{
    rm -f /usr/bin/csbs_manager
    echo '#!/bin/bash'>/usr/bin/csbs_manager
    echo "sudo /opt/huawei/root_tools/cli-client/cmd_manager.sh">>/usr/bin/csbs_manager
    chmod 555 /usr/bin/csbs_manager
}
######################################################################
# 功能说明  : 安装root权限脚本
# 参数 1: 脚本所属服务
# 参数 2：路径源脚本
######################################################################
function install_root_tools()
{
    mkdir -p "/opt/huawei/root_tools/$1"
    /usr/bin/cp -f "$2" "/opt/huawei/root_tools/$1"
    file_name=$(basename "$2")
    chmod 500 "/opt/huawei/root_tools/$1/${file_name}"
}
######################################################################
# 功能说明  : 安装omm-ha主备资源
######################################################################
function install_ommha_resource()
{
    mkdir -p /opt/huawei/dj/bin/ha/module/harm/plugin/{script,conf}
    /usr/bin/cp -rf "$1/script" "$1/conf" /opt/huawei/dj/bin/ha/module/harm/plugin
    chmod 500 /opt/huawei/dj/bin/ha/module/harm/plugin/script/*
    set_modify_permission /opt/huawei/dj/bin/ha/module/harm/plugin/conf
}
######################################################################
# 功能说明  : 获取服务升级顺序 -1不升级  1第一批升级 2第二批升级 3第三批升级
######################################################################
function get_service_upgrade_order()
{
    new_version="$1/conf/$2.ver"
    old_version="/opt/huawei/dj/versions/$2.ver"
    if [[ -f "$1/$2_upgrade_finish" ]];then
        log_info "Current node $2 had finish upgrade."
        echo -1 && return
    elif [[ ! -f ${new_version} ]];then
        log_info "Current services package is error, not allow upgrade $2."
        echo -1 && return
    elif [[ ! -f "${old_version}" ]];then
        log_info "Current not install $2."
        [[ "$2" != "omm-ha" ]] && [[ "$2" != "gaussdb" ]] && echo 1
        echo -1 && return
    fi
    new_version=$(cat "${new_version}")
    old_version=$(cat "${old_version}")
    if [[ "${new_version}" == "${old_version}" ]];then
        log_info "$2 version(${old_version}) is same as target, but not exist finish tag. will redo upgrade."
        echo 1 && return
    fi
    current_ver=$(printf '%s\n' "${new_version}" "${old_version}" | sort -V | head -n 1)
    if [[ "${current_ver}" == "${new_version}" ]];then
        log_info "$2 version(${old_version}) is more than target version(${new_version}). not need upgrade."
        echo -1 && return
    fi
    log_info "Will upgrade $2 from ${old_version} to ${new_version}."
    [[ "$2" != "omm-ha" ]] && [[ "$2" != "gaussdb" ]] && echo 1 && return
    get_info node_index
}
######################################################################
# 功能说明  : 验证数据库是否可用
######################################################################
function test_gaussdb_connect()
{
    (
        echo "from basesdk import db_client"
        echo "try:"
        echo "    exit(db_client.test_gaussdb_connect())"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
######################################################################
# 功能说明  : 创建数据库帐号
######################################################################
function create_user_in_role()
{
    export CSBS_PYTHON_DATA1="$1"
    export CSBS_PYTHON_DATA2="$2"
    (
        echo "import os"
        echo "from basesdk import db_client"
        echo "from basesdk import utils"
        echo "try:"
        echo "    db_admin = utils.get_info('gaussdb_admin_user')"
        echo "    db_user = os.getenv('CSBS_PYTHON_DATA1')"
        echo "    db_pass = os.getenv('CSBS_PYTHON_DATA2')"
        echo "    exit(db_client.create_user_in_role(db_admin, db_user, db_pass))"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
######################################################################
# 功能说明  : 创建数据库
######################################################################
function create_db_for_owner()
{
    export CSBS_PYTHON_DATA="$1"
    (
        echo "import os"
        echo "from basesdk import db_client"
        echo "from basesdk import utils"
        echo "try:"
        echo "    db_admin = utils.get_info('gaussdb_admin_user')"
        echo "    db_name = os.getenv('CSBS_PYTHON_DATA')"
        echo "    exit(db_client.create_db_for_owner(db_name, db_admin))"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}