#!/bin/bash
LINE_ROOT=$(dirname "$(readlink -f "$0")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

# 入参判断
if [ $# -ne 2 ] || [ "$1" != "-f" ] ||  [ ! -f "$2" ]; then
    ECHO_RETURN 1 "Usage: ${LINE_ROOT}/install.sh -f [config file patch]"
fi

# pyhton环境
log_info "begin install python thirdparty"
tar -P -xzf "${LINE_ROOT}/repo/third_party/python.tar.gz"  >/dev/null 2>&1
ECHO_RETURN $? "install python rpm failed!"

# 服务部署
csbs_python "${LINE_ROOT}/bin/srvmanager.py" install "$2"
CHECK_RESULT $? "Install backup service failed."
exit 0