#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init alarm rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/alarm
    log_info "Finish alarm rsyslog configuration."
}

function install_version()
{
    log_info "Init alarm version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/alarm.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy alarm version Failed."
    log_info "Finish alarm version configuration."
}

function install_script()
{
    log_info "Init alarm script configuration."
    alarm_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "alarm*.whl")
    csbs_python -m pip install --no-deps --force-reinstall "${alarm_whl}"
    CHECK_RESULT $? "pip install alarm failed."
    log_info "Finish alarm script configuration."
}

function install_tools()
{
    log_info "Init alarm tools configuration."
    mkdir -p /opt/huawei/dj/tools/alarm
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/alarm
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/alarm/alarmControl.sh
    log_info "Finish alarm tools configuration."
}

function install_permission()
{
    log_info "Init alarm permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    log_info "Finish alarm permission configuration."
}

function install_root()
{
    log_info "Init alarm root configuration."
    log_info "Finish alarm root configuration."
}

function install_conf()
{
    log_info "Init alarm conf configuration."
    log_info "Finish alarm conf configuration."
}

function install_crontab()
{
    log_info "Init alarm crontab configuration."
    log_info "Finish alarm crontab configuration."
}

log_info "Start alarm installation."
install_rsyslog
install_script
install_root
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish alarm installation."
