#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo "$(readlink -f "$0")" "$@";exit $?
fi
# 外部输入参数使用前需要校验
# 参数1为时分格式
[[ $# -gt 1 ]] && exit 1
INPUT_TIME="$1"

TOOL="/opt/huawei/dj/tools/backup/gaussdb_backup_entry.sh"
if [[ $# -eq 0 ]];then
    sed -i "\%${TOOL}%d" /etc/cron.d/crontab_backup.conf
    exit 0
fi

source /opt/huawei/root_tools/base/root_utils.sh
check_hour_minute "${INPUT_TIME}" >/dev/null 2>&1 || exit 2
IFS=":" read -r -a TIME <<< "${INPUT_TIME}"
sed -i "\%${TOOL}%d" /etc/cron.d/crontab_backup.conf
echo "${TIME[1]} ${TIME[0]} * * * openstack /bin/bash ${TOOL} auto" >> /etc/cron.d/crontab_backup.conf
service cron restart