#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="gaussdbBackup"
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
BACKUP_PATH='/opt/huawei/djbackup/manualbk'
PARAM=''
TIMEOUT=900
HOST_IP=$(get_info manage_ip)


function clear_backup_dir()
{
    [[ ! -d ${BACKUP_PATH} ]] && return 0
    backup_dirs=$(find ${BACKUP_PATH} -maxdepth 1 -type d)
    while IFS= read -r dir;do
        [[ "${dir}" != "${BACKUP_PATH}" ]] && rm -rf "${dir}"
    done <<< "${backup_dirs}"
    return 0
}

#delete redundant file while it beyond 7 backup files;
function delete_redundant_file()
{
    check_file=$(find ${BACKUP_PATH} -type f -name "gaussdb_backup*" -exec ls -t {} +)
    file_num=0
    while IFS= read -r file;do
        if [[ ${file_num} -gt 7 ]];then
            rm -f "${file}"
            echo_info "delete oldest backup file: ${file}"
        fi
        file_num=$((file_num+1))
    done <<< "${check_file}"
    return 0
}

function check_backup_result()
{
    [[ "$1" -eq 0 ]] && return
    [[ "${PARAM}" == "auto" ]] && send_alarm 1023295 >/dev/null 2>&1
    echo_error "$2"
    clear_backup_dir
    exit "$1"
}

function upload_auto_backup_data()
{
    [[ "${PARAM}" != "auto" ]] && return
    clear_backup_dir && delete_redundant_file
    upload_backup_data -c /opt/huawei/dj/etc/backup/log_agent_dj.json >/dev/null 2>&1
    check_backup_result $? "upload backup file and log file failed."
    clear_alarm 1023295 >/dev/null 2>&1
    echo_info "success to upload backup file and log file."
}

function main()
{
    echo_info "Starting to back up data"
    clear_backup_dir
    primary_node=$(get_primary_db_node)
    check_backup_result $? "Failed to obtain master database node. Ensure that the database service is normal."
    echo_info "primary node is ${primary_node}"
    #current node is primary node
    if [[ "${HOST_IP}" == "${primary_node}" ]];then
        echo_info "current node ${HOST_IP} is the primary."
        mkdir -p ${BACKUP_PATH}
        sh "${CURRENT_PATH}/gaussdb_backup.sh" ${BACKUP_PATH}
        check_backup_result $? "failed to backup gaussdb on current node ${HOST_IP}."
        upload_auto_backup_data
        echo_info "backup gaussdb successfully on current node ${HOST_IP}."
    elif [[ "${PARAM}" != "auto" ]];then
        echo_info "execute backup on remote node ${primary_node}"
        cmd_manager --node_ip "${primary_node}" --cmd "${CURRENT_PATH}/gaussdb_backup.sh" --parameters "${BACKUP_PATH}" --timeout "${TIMEOUT}"
        check_backup_result $? "failed to backup gaussdb on remote node ${primary_node}."
        echo_info "backup gaussdb on successfully on remote node ${primary_node}."
    else
        upload_auto_backup_data
    fi
}

# 防止并发
if [[ "$(pgrep -U 51001 -f "$0" -d ' ')" != "$$" ]];then
    ECHO_RETURN 1 "The script is running, no need start again."
fi

if [[ $# -gt 2 ]];then
    echo "A maximum of two parameters can be transferred." && exit 1
fi

if [[ $# -ge 1 ]] && [[ "$1" == "auto" ]];then
    BACKUP_PATH='/opt/huawei/djbackup/db'
    PARAM='auto'
fi
if [[ $# -eq 2 ]];then
    if [[ "$2" -gt 0 ]] ;then
        TIMEOUT="$2"
    else
        echo "The second parameter indicates the timeout interval. Enter an integer greater than 0." && exit 1
    fi
fi
main
