#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="cli-client"

[[ "$1" != "ascagent.backup.backup_conf" ]] && CHECK_RESULT 1 "$1 is not backup watcher key."

POLICY=$(get_cms_info "${1}")
if [[ -z "${POLICY}" ]];then
    CHECK_RESULT 1 "${1} data is empty."
fi
function get_time_info()
{
    export CSBS_PYTHON_DATA="$*"
    (
        echo "import os"
        echo "import json"
        echo "try:"
        echo "    value = os.getenv('CSBS_PYTHON_DATA')"
        echo "    data = json.loads(value)"
        echo "    print(data[3].get('gaussdb')[0].get('value'))"
        echo "except Exception:"
        echo "    print('')"
    ) | csbs_python
}
TIME=$(get_time_info "${POLICY}")
if [[ -z "${TIME}" ]];then
    log_error "${KEY} time is empty."
    exit 1
fi
sudo /opt/huawei/root_tools/backup/update_crontab_conf.sh "${TIME}"
exit $?