#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="update_kmc_key"
KEY="kmc.mk_auto_update_policy"

if [[ "$(get_db_role)" != "Primary" ]];then
    log_info "This is not primary node, skipped."
    exit 0
fi

policy=$(get_cms_info "${KEY}")
CHECK_RESULT $? "Can not get mk_auto_update_policy from cms."
interval_days=$(get_dict_info "${policy}" "interval_days")
[[ -z "${interval_days}" ]] && CHECK_RESULT 1 "The auto_update_policy is incorrect data."
interval_seconds=$((interval_days*24*60*60))
last_update_time=$(get_dict_info "${policy}" "last_update_time")
[[ -z "${last_update_time}" ]] && CHECK_RESULT 1 "The auto_update_policy is incorrect data."
now=$(date +%s)
passed_time=$((now-last_update_time))
if [[ "${passed_time}" -lt "${interval_seconds}" ]];then
    log_info "It's not time to update master key, skipped."
    exit 0
fi

bash /opt/huawei/dj/tools/base/kmc_update_master_key.sh
CHECK_RESULT $? "Auto update master key failed, try again tomorrow."

function get_new_policy()
{
    export CSBS_PYTHON_DATA1="$1"
    export CSBS_PYTHON_DATA2="$2"
    (
        echo "import os"
        echo "import json"
        echo "policy = os.getenv('CSBS_PYTHON_DATA1')"
        echo "value = os.getenv('CSBS_PYTHON_DATA2')"
        echo "try:"
        echo "    policy = json.loads(policy)"
        echo "    policy['last_update_time']=value"
        echo "    print(policy)"
        echo "except Exception:"
        echo "    print(policy)"
    ) | csbs_python
}

new_policy=$(get_new_policy "${policy}" "${now}")
put_cms_info "${KEY}" "${new_policy}"
CHECK_RESULT $? "Refresh last update time failed."
log_info "Refresh last update time success."