#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_python()
{
    tar -P -xzf "${LINE_ROOT}/repo/third_party/python.tar.gz"  >/dev/null 2>&1
    CHECK_RESULT $? "install python rpm failed!"
}

function upgrade_base()
{
    sh "${CURRENT_PATH}/install.sh"  >/dev/null 2>&1
    CHECK_RESULT $? "failed to run base install when upgrade"
    sh "${CURRENT_PATH}/config.sh"  >/dev/null 2>&1
    CHECK_RESULT $? "failed to run base config when upgrade"
    log_info "upgrade base success."
}

log_info "begin base Upgrade."
install_python
upgrade_base
touch "${CURRENT_PATH}/base_upgrade_finish"
log_info "Upgrade base success."