#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"
DB_PWD=$(awk '{print $NF}' /opt/huawei/dj/DJSecurity/privkey/privkey.conf)

[[ -f "${LINE_ROOT}/cms.conf" ]] && /usr/bin/cp -f "${LINE_ROOT}/cms.conf" /opt/huawei/dj/etc/cms/cms.conf && exit 0
cmd_retry test_gaussdb_connect 120 10
CHECK_RESULT $? "Gauss db is not normal"
log_info "Gauss db is normal"

log_info "Start create cms_a user"
create_user_in_role "cms_a" "${DB_PWD}"
CHECK_RESULT $?  "Create db user cms_a failed"
log_info "Success create cms_a user"

log_info "Start creat cms_b user"
create_user_in_role "cms_b" "${DB_PWD}"
CHECK_RESULT $? "Create db user cms_b failed"
log_info "Success create cms_b user"

log_info "Start create cms database"
create_db_for_owner "cms"
CHECK_RESULT $? "Create db cms failed"
log_info "Success create cms database"

log_info "Start sync cms configuration"
sed -i "s/db_cms_password/${DB_PWD}/g" /opt/huawei/dj/etc/cms/cms.conf
sync_config /opt/huawei/dj/etc/cms/cms.conf /opt/huawei/dj/etc/cms/cms_config.json
CHECK_RESULT $? "sync cms configuration failed"
log_info "Success sync cms configuration"