#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"
UTIL_CONF="${LINE_ROOT}/cfg/util.conf"
RABBITMQ_PWD=$(awk '{print $NF}' /opt/huawei/dj/DJSecurity/privkey/privkey.conf)
WEAK_PWD=$(decrypt_pwd "$(get_pwd weak_pwd "${UTIL_CONF}")")

function save_ini_info()
{
    (
        echo "from basesdk import cms_info"
        echo "try:"
        echo "    cms_info.save_ini()"
        echo "    exit(0)"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}

log_info "Begin to save ini."
save_ini_info
CHECK_RESULT  $? "Save ini failed."
put_cms_info "weak_pwd" "${WEAK_PWD}"
CHECK_RESULT  $? "Save weak_pwd failed."
put_cms_info "rabbitmq.pwd" "${RABBITMQ_PWD}"
CHECK_RESULT  $? "Save rabbitmq_pwd failed."
log_info "Save Config finished."
exit 0