#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
TARGET_PKG="/opt/huawei/djcollect/DataCollect.tar.gz"
IFS="," read -r -a NODE_LIST <<< "$(get_info manage_ip_list)"
for node in "${NODE_LIST[@]}";do
    cmd_manager --node_ip "${node}" --cmd "${CURRENT_PATH}/DataCollect.sh" --parameters "$1" >/dev/null 2>&1
done
if [[ "$1" != "finish" ]];then
    exit 0
fi
for node in "${NODE_LIST[@]}";do
    download_file --node_ip "${node}" --source_file "${TARGET_PKG}" --target_file "/home/openstack/DataCollect_${node}.tar.gz"
done
rm -rf "/home/openstack/DataCollect.tar.gz" && cd /home/openstack || exit 1
tar -czf DataCollect.tar.gz DataCollect_*.tar.gz --remove-files >/dev/null 2>&1